package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.StringHelper;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.transform.Transformers;
import org.json.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.math.BigDecimal;
import java.util.*;

/**
 * 根据小区 信息建立该栋档案
 */
@Path("archives")
@Component
@Transactional
public class ArchivesCreate {

	static Logger log = Logger.getLogger(ArchivesCreate.class);
	@Autowired
	private SqlServer sqlServer;
	@Autowired
	private EntityServer entityServer;
	@Autowired
	private HibernateTemplate hibernateTemplate;

	@Autowired
	private SessionPool sessionPool;

	public Session assignedSession;

	/**
	 * {
	 * "areaid":"",
	 * "building_min":1,
	 * "building_max":3,
	 * "unit_min":1,
	 * "unit_max":2,
	 * "floor_min":1,
	 * "floor_max":28,
	 * "room_min":10001,
	 * "room_max":10005
	 * }
	 * @param jsonstr
	 * @return
	 */

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	public String Create(String jsonstr) {
		try {
			//开启事务
			Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
			String result = "接收成功";
			//获取得到数据
			JSONObject json = new JSONObject(jsonstr);
			//公共数据
			JSONObject objdata = new JSONObject();
			//得到小区ID
			String areaid = json.getString("areaid");
			JSONObject areajson = new JSONObject();
			areajson.put("id", areaid);
			JSONArray arealist = sqlServer.query("import_getAreaMsg", areajson);
			// 未找到站点
			if (arealist.length() != 1) {
				return "未找到小区信息";
			} else {
				objdata = arealist.getJSONObject(0);
			}

			long begin = System.currentTimeMillis();
			//得到建档人
			String man = json.getString("man");
			//得到操作ID
			String op_id = json.getString("op_id");
			//得到操作站点
			String op_spot = json.getString("op_spot");
			//所属公司
			String f_subunit = json.getString("f_subunit");
			objdata.put("f_subunit",f_subunit);
			objdata.put("op_spot",op_spot);
			objdata.put("man",man);
			objdata.put("op_id",op_id);
			//得到楼栋区间
			Integer building_min = json.getInt("building_min");
			Integer building_max = json.getInt("building_max");
			//得到单元区间
			Integer unit_min = json.getInt("unit_min");
			Integer unit_max = json.getInt("unit_max");
			//得到楼层区间
			Integer floor_min = json.getInt("floor_min");
			Integer floor_max = json.getInt("floor_max");
			//得到房间区间
			Integer room_min = json.getInt("room_min");
			Integer room_max = json.getInt("room_max");
			//得到数据格式
			Integer sum = (building_max - building_min + 1) * (unit_max - unit_min + 1) * (floor_max - floor_min + 1) * (room_max - room_min + 1);
			log.error("总共批量插入户数是：" + sum);
			//得到地址序列号
			List<Object> address_seq = this.getSeqList("seq_user_address_id", sum);
			//得到户档案序列号
			List<Object> userinfo_seq = this.getSeqList("seq_userinfo_id", sum);
			//得到表档案序列号
			List<Object> userfiles_seq = this.getSeqList("seq_userfiles_id", sum);

			List<Object> cradarry=this.getCardList1(areaid,sum);
			//得到地址数据
			ArrayList<HashMap<String, Object>> addressarry = this.getAddressList(objdata,json,address_seq,userinfo_seq);
			Boolean addressflag=this.InsertData(addressarry,"t_user_address");
			if(!addressflag){
				return "地址插入失败";
			}
			//得到户数据
			ArrayList<HashMap<String, Object>> userinfoarry = this.getUserinfoList(objdata,json,address_seq,userinfo_seq,cradarry);
			Boolean userinfoflag=this.InsertData(userinfoarry,"t_userinfo");
			if(!userinfoflag){
				return "户档案插入失败";
			}
			//得到户数据
			ArrayList<HashMap<String, Object>> userfilesarry = this.getUserfilesList(objdata,json,address_seq,userinfo_seq,userfiles_seq,cradarry);
			Boolean userfilesflag=this.InsertData(userfilesarry,"t_userfiles");
			if(!userfilesflag){
				return "表档案档案插入失败";
			}
			long end = System.currentTimeMillis();
			log.debug("总体：" + (end - begin) + "ms");
			return result;
		}catch (Exception e){
			//回滚事务，如果出错的话
			this.hibernateTemplate.getSessionFactory().getCurrentSession().getTransaction().rollback();
			log.error("批量插入保存" + e.getMessage());
			return "02|;";
		}
	}

	/**
	 * 批量插入数据
	 * @param arry
	 * @param tablename
	 * @return
	 */
	private Boolean InsertData(ArrayList<HashMap<String, Object>> arry,String tablename){
		Boolean flag=false;
		int p = 0;
		if (arry.size() % 1000 == 0) {
			p = arry.size() / 1000;
		} else {
			p = arry.size() / 1000 + 1;
		}
		log.debug("共" + p + "批");
		for (int k = 1; k <= p; k++) {
			String headstr = "( ";
			String sqlstr = "";
			String valuestr = "";
			HashMap<String, Object> head = arry.get(0);
			for (String key : head.keySet()) {
				headstr = headstr + "" + key + ",";
			}
			headstr = headstr.substring(0, headstr.length() - 1) + ")";
			if (k == p) {
				log.debug("第" + k + "批的1000条开始");
				sqlstr = "INSERT INTO "+tablename+" ";
				valuestr = "select ";
				//得到表头
				for (int l = (k - 1) * 1000; l < arry.size(); l++) {
					//得到单个对象值 需要拿值组装语句
					HashMap<String, Object> one = arry.get(l);
					for (String key : one.keySet()) {
						if (one.get(key) instanceof Integer) {
							valuestr = valuestr + "" + one.get(key) + ",";
						} else {
							valuestr = valuestr + "'" + one.get(key) + "',";
						}
					}
					if (l == (arry.size()-1)) {
						//如果长度达到的话 去除union select
						valuestr = valuestr.substring(0, valuestr.length() - 1) + "from dual ";
					} else {
						valuestr = valuestr.substring(0, valuestr.length() - 1) + "from dual union select ";
					}
				}
				this.executeSQL(sqlstr + headstr + "  " + valuestr);
				log.debug("第" + k + "批的1000条结束");
			}else {
				log.debug("第" + k + "批的1000条开始");
				sqlstr = "INSERT INTO "+tablename+" ";
				valuestr = "select ";
				//得到表头
				for (int l = (k - 1) * 1000; l < k * 1000; l++) {
					HashMap<String, Object> one = arry.get(l);
					for (String key : one.keySet()) {
						if (one.get(key) instanceof Integer) {
							valuestr = valuestr + "" + one.get(key) + ",";
						} else {
							valuestr = valuestr + "'" + one.get(key) + "',";
						}
					}
					if (l == (k * 1000)-1) {
						valuestr = valuestr.substring(0, valuestr.length() - 1) + "from dual ";
					} else {
						valuestr = valuestr.substring(0, valuestr.length() - 1) + "from dual union select ";
					}
				}
				sqlstr = sqlstr + headstr + "  " + valuestr;
				this.executeSQL(sqlstr);
				log.debug("第" + k + "批的1000条结束");
			}
		}
		flag=true;
		return flag;
	}
	/**
	 *
	 * @param json 前台传来的数据
	 * @param address_seq 地址序列
	 * @param userinfo_seq 用户序列
	 * @return
	 * @throws Exception
	 */
	private ArrayList<HashMap<String, Object>> getAddressList(JSONObject objdata,JSONObject json,List<Object> address_seq,List<Object> userinfo_seq) throws Exception {
		ArrayList<HashMap<String, Object>> addressarry = new ArrayList<>();

		//得到楼栋区间
		Integer building_min = json.getInt("building_min");
		Integer building_max = json.getInt("building_max");
		//得到单元区间
		Integer unit_min = json.getInt("unit_min");
		Integer unit_max = json.getInt("unit_max");
		//得到楼层区间
		Integer floor_min = json.getInt("floor_min");
		Integer floor_max = json.getInt("floor_max");
		//得到房间区间
		Integer room_min = json.getInt("room_min");
		Integer room_max = json.getInt("room_max");

		int h = 0;
		//*************【地址部分】
		//开始生成地址列表
		for (int i = building_min; i <= building_max; i++) {
			for (int j = unit_min; j <= unit_max; j++) {
				for (int m = floor_min; m <= floor_max; m++) {
					for (int n = room_min; n <= room_max; n++) {
						HashMap<String, Object> addmap = new HashMap<>();
						addmap.put("f_pcd", objdata.get("f_pcd"));
						addmap.put("op_id", objdata.get("op_id"));
						addmap.put("op_spot", objdata.get("op_spot"));
						addmap.put("f_create_person", objdata.get("man"));
						addmap.put("f_street", objdata.get("f_street"));
						addmap.put("f_pcd_id", objdata.get("f_pcd_id"));
						addmap.put("f_street_id", objdata.get("f_street_id"));
						addmap.put("f_slice_area", objdata.get("f_slice_area"));
						addmap.put("f_residential_area_id", objdata.get("f_residential_area_id"));
						addmap.put("f_residential_area", objdata.get("f_residential_area"));
						addmap.put("oldareaid", objdata.get("oldareaid"));
						addmap.put("f_building", i);
						addmap.put("f_unit", j);
						addmap.put("f_floor", m);
						addmap.put("f_room", n);
						addmap.put("f_building_suffix", "栋");
						addmap.put("f_unit_suffix", "单元");
						addmap.put("f_floor_suffix", "层");
						addmap.put("f_room_suffix", "室");
						addmap.put("f_address", objdata.getString("f_pcd") + objdata.getString("f_street") + objdata.getString("f_residential_area")
								+ i + "栋" + j + "单元" + m + "层" + n + "室"
						);
						//地址序列号
						addmap.put("id", ((HashMap) address_seq.get(h)).get("SEQID"));
						//用户序列号
						addmap.put("f_userinfo_id", ((HashMap) userinfo_seq.get(h)).get("SEQID"));
						addressarry.add(addmap);
						h++;
					}
				}
			}
		}
		return addressarry;
	}

	/**
	 *
	 * @param json 前台传来的数据
	 * @param address_seq 地址序列
	 * @param userinfo_seq 用户序列
	 * @return
	 * @throws Exception
	 */
	private ArrayList<HashMap<String, Object>> getUserinfoList(JSONObject objdata,JSONObject json,List<Object> address_seq,List<Object> userinfo_seq,List<Object> cardlist) throws Exception {
		ArrayList<HashMap<String, Object>> userinfoarry = new ArrayList<>();
		//得到楼栋区间
		Integer building_min = json.getInt("building_min");
		Integer building_max = json.getInt("building_max");
		//得到单元区间
		Integer unit_min = json.getInt("unit_min");
		Integer unit_max = json.getInt("unit_max");
		//得到楼层区间
		Integer floor_min = json.getInt("floor_min");
		Integer floor_max = json.getInt("floor_max");
		//得到房间区间
		Integer room_min = json.getInt("room_min");
		Integer room_max = json.getInt("room_max");
		int h = 0;
		//*************【地址部分】
		//开始生成地址列表
		for (int i = building_min; i <= building_max; i++) {
			for (int j = unit_min; j <= unit_max; j++) {
				for (int m = floor_min; m <= floor_max; m++) {
					for (int n = room_min; n <= room_max; n++) {
						HashMap<String, Object> addmap = new HashMap<>();
						addmap.put("f_subunit", objdata.get("f_subunit"));
						addmap.put("f_credentials", objdata.get("f_credentials"));
						addmap.put("op_id", objdata.get("op_id"));
						addmap.put("op_spot", objdata.get("op_spot"));
						addmap.put("f_createfile_person", objdata.get("man"));
						addmap.put("f_operator", objdata.get("man"));
						addmap.put("f_subunit", objdata.get("f_subunit"));
						addmap.put("f_subordinate_company", objdata.get("f_residential_area"));
						addmap.put("f_use_company", objdata.get("f_residential_area"));
						addmap.put("f_userinfo_code", cardlist.get(h));
						addmap.put("f_cost_type", objdata.get("f_cost_type"));
						addmap.put("f_user_state", objdata.get("f_user_state"));
						//地址序列号
						addmap.put("f_useraddress_id", ((HashMap) address_seq.get(h)).get("SEQID"));
						//用户序列号
						addmap.put("f_userinfo_id", ((HashMap) userinfo_seq.get(h)).get("SEQID"));
						userinfoarry.add(addmap);
						h++;
					}
				}
			}
		}
		return userinfoarry;
	}


	private ArrayList<HashMap<String, Object>> getUserfilesList(JSONObject objdata,JSONObject json,List<Object> address_seq,List<Object> userinfo_seq,List<Object> userfiles_seq,List<Object> cardlist) throws Exception {
		ArrayList<HashMap<String, Object>> userfilesoarry = new ArrayList<>();
		//得到楼栋区间
		Integer building_min = json.getInt("building_min");
		Integer building_max = json.getInt("building_max");
		//得到单元区间
		Integer unit_min = json.getInt("unit_min");
		Integer unit_max = json.getInt("unit_max");
		//得到楼层区间
		Integer floor_min = json.getInt("floor_min");
		Integer floor_max = json.getInt("floor_max");
		//得到房间区间
		Integer room_min = json.getInt("room_min");
		Integer room_max = json.getInt("room_max");
		int h = 0;
		//开始生成地址列表
		for (int i = building_min; i <= building_max; i++) {
			for (int j = unit_min; j <= unit_max; j++) {
				for (int m = floor_min; m <= floor_max; m++) {
					for (int n = room_min; n <= room_max; n++) {
						HashMap<String, Object> addmap = new HashMap<>();
						addmap.put("f_user_id", ((HashMap) userfiles_seq.get(h)).get("SEQID"));
						addmap.put("f_userinfo_id", ((HashMap) userinfo_seq.get(h)).get("SEQID"));
						addmap.put("f_useraddress_id", ((HashMap) address_seq.get(h)).get("SEQID"));
						addmap.put("f_card_id", cardlist.get(h));
						addmap.put("op_id", objdata.get("op_id"));
						addmap.put("op_spot", objdata.get("op_spot"));
						addmap.put("f_input_person", objdata.get("man"));
						addmap.put("f_operator", objdata.get("man"));
						addmap.put("f_subunit", objdata.get("f_subunit"));
						addmap.put("f_price_id", objdata.getInt("f_price_id"));
						addmap.put("f_user_type", objdata.getString("f_user_type"));
						addmap.put("f_gasproperties", objdata.getString("f_gasproperties"));
						addmap.put("f_whether_hairpin", objdata.getString("f_whether_hairpin"));
						addmap.put("f_meter_classify", objdata.get("f_meter_classify"));
						addmap.put("f_gasbrand_id", objdata.getInt("f_gasbrand_id"));
						addmap.put("f_gasmodel_id", objdata.getInt("f_gasmodel_id"));
						addmap.put("f_table_state", objdata.get("f_table_state"));
						addmap.put("alarm", objdata.getInt("alarm"));
						addmap.put("constant", objdata.get("constant"));
						addmap.put("is_close", objdata.get("is_close"));
						addmap.put("is_close_one", objdata.getInt("is_close_one"));
						addmap.put("is_close_two", objdata.getInt("is_close_two"));
						addmap.put("is_tablelimit", objdata.getString("is_tablelimit"));
						addmap.put("is_tablelimit_gas", objdata.getInt("is_tablelimit_gas"));
						addmap.put("price_type", objdata.getString("price_type"));
						addmap.put("anjianyear", objdata.getInt("anjianyear"));
						addmap.put("baofeiyear", objdata.getInt("baofeiyear"));
						addmap.put("onealarm", objdata.getInt("onealarm"));
						addmap.put("twoalarm", objdata.getInt("twoalarm"));
						addmap.put("f_isic", objdata.getString("f_isic"));
						//用户序列号

						userfilesoarry.add(addmap);
						h++;
					}
				}
			}
		}
		return userfilesoarry;
	}

	/**
	 * 执行sql返回数据
	 *
	 * @param sql
	 * @return
	 */
	private List<Object> executeSQLData(String sql) {
		List<Object> list = (List<Object>) hibernateTemplate
				.execute(new org.springframework.orm.hibernate4.HibernateCallback() {
					public Object doInHibernate(Session session)
							throws HibernateException {
						SQLQuery query = session.createSQLQuery(sql);
						return (List) query.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).list();
					}
				});
		return list;
	}
	/**
	 * 执行sql返回数据
	 *
	 * @param sql
	 * @return
	 */
	private void executeSQL(String sql) {
		int list = (int)hibernateTemplate
				.execute(new org.springframework.orm.hibernate4.HibernateCallback() {
					public Object doInHibernate(Session session)
							throws HibernateException {
						long begin = System.currentTimeMillis();
						SQLQuery query = session.createSQLQuery(sql);
						int result = query.executeUpdate();
						long end = System.currentTimeMillis();
						log.debug("执行SQL:{\n" + sql + "\n}耗时：" + (end - begin) + "ms");
						return result;
					}
				});
	}
	/**
	 * 获取序列号
	 * @param seqstr
	 * @param num
	 * @return
	 */
	private List<Object> getSeqList(String seqstr,Integer num) {
		String sql="select "+seqstr+".nextval seqid from (select 1 from all_objects where rownum <= "+num+")";
		List<Object> list = this.executeSQLData(sql);
		return list;
	}
	/**
	 * 获取卡号 根据起止卡号来处理数据 锁表所t_area
	 * @param key
	 * @param len
	 * @param num
	 * @return
	 * @throws Exception
	 */
	public ArrayList getCardList1(String key, int num) throws Exception {
		ArrayList arry =new ArrayList();
		BigDecimal card_size =new BigDecimal(0);
		String card_start = "";
		String newcard_start = "";
		String sql = "";
		sql = "select * from t_area where id='" + key + "' for update";
		JSONArray array = sqlServer.query(sql);
		if (array.length() > 0) {
			JSONObject json=array.getJSONObject(0);
			card_start = json.getString("card_start");
			card_size = json.getBigDecimal("card_size");
			newcard_start = ((Integer.parseInt(card_start))+num)+"";
			while (newcard_start.length()<10){
				newcard_start="0"+newcard_start;
			}
			json.put("card_start",newcard_start);
			json.put("card_size",card_size.subtract(BigDecimal.valueOf(num)));
			JSONObject data=new JSONObject();
			data.put("data",json);
			entityServer.save("t_area", data.toString());
		}
		// 如果有长度限制，前面补0
		for (int i=Integer.parseInt(card_start) ;i<Integer.parseInt(newcard_start);i++){
			String cardnum=i+"";
			while (cardnum.length()<10){
				cardnum="0"+cardnum;
			}
			arry.add(cardnum);
		}
		// 否则，直接返回
		return arry;
	}
	/**
	 * 获取卡号
	 * @param key
	 * @param len
	 * @param num
	 * @return
	 * @throws Exception
	 */
	public ArrayList getCardList(String key, int len, int num) throws Exception {
		ArrayList arry =new ArrayList();
		long value = 0;
		long newvalue = 0;
		int id = -1;
		String sql = "";
		if (entityServer.findDialect() == "SqlServer") {
			sql = "select id, f_key, f_value from t_sequence with(updlock,rowlock) where f_key='" + key + "'";
		} else {
			sql = "select id, f_key, f_value from t_sequence where f_key='" + key + "' for update";
		}
		JSONArray array = sqlServer.query(sql);
		if (array.length() > 0) {
			newvalue = array.getJSONObject(0).getLong("f_value");
			value = array.getJSONObject(0).getLong("f_value");
			id = array.getJSONObject(0).getInt("id");
		}
		newvalue=num+newvalue;
		// 保存结果
		if (id == -1) {
			entityServer.save("t_sequence", "{data: {f_key: '" + key + "', f_value: " + newvalue + "}}");
		} else {
			entityServer.save("t_sequence", "{data: {id: " + id + ", f_key: '" + key + "', f_value: " + newvalue + "}}");
		}
		// 如果有长度限制，前面补0
		for (int i=(int)value ;i<=newvalue;i++){
			String result = i + "";
			int resultLen = result.length();
			if (len != 0 && resultLen < len) {
				result = key+StringHelper.repeate('0', len - resultLen) + result;
			}
			arry.add(result);
		}
		// 否则，直接返回
		return arry;
	}
}
