package com.aote.helper;

import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import org.json.JSONObject;
import sun.misc.BASE64Encoder;
import com.aote.util.StringHelper;
import org.apache.log4j.Logger;
import org.json.JSONArray;

import java.math.BigDecimal;
import java.util.Set;

/**
 * 编号产生器
 */
public class Util {
	static Logger log = Logger.getLogger(LogicServer.class);


	/**
	 * 比较两个JSONObject,  返回的JSONArray格式为[{field:xxx, oldVal:xxx, newVal: xxx}]
	 *
	 * @param jo1 新值
	 * @param jo2 旧值
	 * @return JSONArray
	 */
	public static JSONArray findDiff(JSONObject jo1, JSONObject jo2) {
		JSONArray jsonArray;
		Set<String> keySet1 = jo1.keySet();
		jsonArray = new JSONArray();
		for (String s : keySet1) {
			if (isValueEquals(jo1, jo2, s)) {
				JSONObject jo = new JSONObject();
				jo.put("field", s);
				jo.put("newVal", jo1.get(s) == null ? null : jo1.get(s)
						.toString().replace("null",""));
				jo.put("oldVal", jo2.get(s) == null ? null : jo2.get(s)
						.toString().replace("null",""));
				jsonArray.put(jo);
			}
		}
		return jsonArray;
	}
	/**
	 * 判断两个json中值是否相同
	 *
	 * @param jo1 新值
	 * @param jo2 旧值
	 * @return 判断结果
	 */
	private static boolean isValueEquals(JSONObject jo1, JSONObject jo2, String s) {
		// 针对级联json数据
		if(jo1.has(s)&&jo2.has(s)){
			if ((jo1.isNull(s) && !jo2.isNull(s))
					|| (!jo1.isNull(s) && jo2.isNull(s))) {
				return true;
			}
		}else {
			return false;
		}
		if (jo1.isNull(s) && (jo2.isNull(s) || "null".equals(jo2.get(s)))) {
			return false;
		}
		if (jo1.get(s) instanceof Integer) {
			if (jo2.get(s) instanceof BigDecimal) {
				return new BigDecimal((Integer) jo1.get(s))
						.compareTo((BigDecimal) jo2.get(s)) != 0;
			} else {
				try {
					return new BigDecimal((Integer) jo1.get(s))
							.compareTo(new BigDecimal(Integer.valueOf(jo2
									.get(s).toString()))) != 0;
				} catch (Exception e) {
					return false;
				}
			}
		}
		if (jo1.get(s) instanceof String) {
			if (jo2.get(s) instanceof String) {
				return !jo1.get(s).equals(jo2.get(s));
			} else {
				try {
					// 界面传过来的是字符串，库里拿到的是BigDecimal类型
					return new BigDecimal(Double.valueOf(jo1.get(s).toString()))
							.compareTo((BigDecimal)jo2.get(s)) != 0;
				} catch (Exception e) {
					return false;
				}
			}
		}
		if (jo1.get(s) instanceof Double) {
			if (jo2.get(s) instanceof Integer) {
				return new BigDecimal((Double) jo1.get(s))
						.compareTo(new BigDecimal((Integer) jo2.get(s))) != 0;
			} else {
				try {
					return new BigDecimal((Double) jo1.get(s))
							.compareTo(new BigDecimal(Double.parseDouble(jo2
									.get(s).toString()))) != 0;
				} catch (Exception e) {
					return false;
				}
			}
		}
		return !(jo2.get(s).equals(jo1.get(s)));
	}


	public static String encode(String error) {
		try {
			return (new BASE64Encoder()).encodeBuffer(error.getBytes("UTF-8"));
		} catch (Exception e) {
			return "";
		}
	}

	/**
	 * 新的编号产生器，所有编号从1开始
	 * @param key 编号主键
	 * @param len 产生的编号长度，不够前面补0。len=0，则不需要补前缀0
	 * @return 产生的编号
	 * @throws Exception 异常
	 */
	public String getSerial(SqlServer sqlServer,EntityServer entityServer,String key, int len) throws Exception {
		long value = 0;
		int id = -1;
		String sql = "";
		if (entityServer.findDialect() == "SqlServer") {
			sql = "select id, f_key, f_value from t_sequence with(updlock,rowlock) where f_key='" + key + "'";
		} else {
			sql = "select id, f_key, f_value from t_sequence where f_key='" + key + "' for update";
		}

		log.debug(sql);
		JSONArray array = sqlServer.query(sql);
		if (array.length() > 0) {
			value = array.getJSONObject(0).getLong("f_value");
			id = array.getJSONObject(0).getInt("id");
		}
		// 编号+1
		value++;
		// 保存结果
		if (id == -1) {
			entityServer.save("t_sequence", "{data: {f_key: '" + key + "', f_value: " + value + "}}");
		} else {
			entityServer.save("t_sequence", "{data: {id: " + id + ", f_key: '" + key + "', f_value: " + value + "}}");
		}

		String result = value + "";
		int resultLen = result.length();
		// 如果有长度限制，前面补0
		if (len != 0 && resultLen < len) {
			result = StringHelper.repeate('0', len - resultLen) + result;
		}
		// 否则，直接返回
		return result;
	}
}
