package com.aote.helper;

import java.util.LinkedList;

import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONObject;

import com.aote.rs.DBService;

public class StringHelper {

	static Logger log = Logger.getLogger(DBService.class);

	/**
	 * Ըַַַָֽ
	 */
	public static LinkedList stringToLinkedList(String source, char ch) {
		LinkedList v = new LinkedList();
		if (source == null || source.equals("")) {
			return v;
		}
		int start = 0;
		int end = source.indexOf(ch);
		while (end != -1) {
			String str = source.substring(start, end);
			v.add(str);
			start = end + 1;
			end = source.indexOf(ch, start);
		}
		String str = source.substring(start);
		v.add(str);
		return v;
	}

	/**
	 * mapе滻str##ʽֵͬ
	 * 
	 * @param map
	 * @param str
	 * @return
	 */
	public static String replaceStr(JSONObject json, String str) {
		String result = replaceStr(json, str, "#");
		return result;
	}

	/**
	 * 滻
	 */
	public static String replaceStr(JSONObject json, String str, String c) {
		// ַÿһ
		StringBuffer sb = new StringBuffer(str);
		int start = sb.indexOf(c);
		while (start != -1) {
			int end = sb.indexOf(c, start + 1);
			if (end == -1) {
				break;
			}
			String name = sb.substring(start + 1, end);
			String value = getValue(json, name);
			// ûֵ滻
			if (value == null || value.equals("")) {
				start = sb.indexOf(c, end + 1);
			} else {
				sb.replace(start, end + 1, value);
				int size = value.length() - name.length();
				start = sb.indexOf(c, end + size);
			}
		}
		return sb.toString();
	}

	private static String getValue(JSONObject json, String name) {
		try {
			// еõֵ
			String value = json.get(name).toString();
			if (value != null && !value.equals("")) {
				return value;
			}
			return null;
		} catch (Exception e) {
			log.debug("滻" + e.getMessage().toString());
			return null;
		}
	}

	/**
	 * ַתjsonobject ʽ: name1:value1|name2:value2....,eg: :20150101|:һ
	 */
	public static JSONObject strToJson( String str, String c) {
		JSONObject result = new JSONObject();
		try {
			String[] strs = str.split(c);
			for (int i = 0; i < strs.length; i++) {
				String oneStr = strs[i];
				String[] oneKeyVal = oneStr.split(":");
				String name = oneKeyVal[0];
				String val = oneKeyVal[1];
				result.put(name, val);
			}
		} catch (Exception e) {
			log.error("滻" + e.getMessage().toString());
			return null;
		}
		return result;
	}

}
