package com.aote.helper;

import java.util.*;

/**
 * ࣬jdk˰װṩ˸ʹ÷ʽ
 */
public class BSCalendar
{
  /**
   * jdkеڱʾ
   */
  private Calendar calendar = null;

  
  /**
	 * ʹù̶ʽַ죬ַʽΪyyyymmddhhttssyyyymmdd
	 */
	public BSCalendar(String time, String format) {
		// ַ
		time = this.clear(time);
		format = this.clear(format);
		
		// ȡ
		int index = format.indexOf("yyyy");
		int year = 0;
		if(index != -1) {
			year = Integer.parseInt(time.substring(index, index+4));
		}
		// ȡ
		index = format.indexOf("mm");
		int month = 0;
		if(index != -1) {
			month = Integer.parseInt(time.substring(index, index+2));
		}
		// ȡ
		index = format.indexOf("dd");
		int dd = 0;
		if(index != -1) {
			dd = Integer.parseInt(time.substring(index, index+2));
		}
		// ȡСʱ
		index = format.indexOf("hh");
		int hour = 0;
		if(index != -1) {
			hour = Integer.parseInt(time.substring(index, index+2));
		}
		// ȡ
		index = format.indexOf("tt");
		int minutes = 0;
		if(index != -1) {
			minutes = Integer.parseInt(time.substring(index, index+2));
		}
		// 
		index = format.indexOf("ss");
		int second = 0;
		if(index != -1) {
			second = Integer.parseInt(time.substring(index, index+2));
		}
		this.calendar = new GregorianCalendar(year, month, dd, hour,
					minutes, second);
	}
  
	
	/**
	 * ַ
	 */
	private String clear(String format) {
		// ַ
		if (format.indexOf("-") != -1) {
			format = format.replaceAll("-", "");
		}
		if (format.indexOf(" ") != -1) {
			format = format.replaceAll(" ", "");
		}
		if (format.indexOf(":") != -1) {
			format = format.replaceAll(":", "");
		}
		return format;
	}

  /**
   * ʹù̶ʽַ죬ַʽΪyyyymmdd
   */
  public BSCalendar(String format)
  {
    //ַȡ꣬£
    int year = Integer.parseInt(format.substring(0, 4));
    int month = Integer.parseInt(format.substring(4, 6)) - 1;
    //û죬ĬΪ1
    int day = 1;
    try
    {
      day = Integer.parseInt(format.substring(6, 8));
    }
    catch (Exception e)
    {
    }
    this.calendar = new GregorianCalendar(year, month, day);
  }

  /**
   * Ʒ
   */
  public Object clone()
  {
    //
    BSCalendar result = new BSCalendar();
    //jdk
    result.calendar = (Calendar)this.calendar.clone();
    return result;
  }

  /**
   * չ
   */
  private BSCalendar()
  {
  }

  /**
   * õϵͳǰ
   */
  public static BSCalendar now()
  {
    //õϵͳǰʱ
    return new BSCalendar(GregorianCalendar.getInstance());
  }

  /**
   * õϵͳǰ
   */
  public static BSCalendar nowMonth()
  {
    String nowmonth = new BSCalendar(GregorianCalendar.getInstance()).toString().
        substring(0, 6);
    return new BSCalendar(nowmonth);
  }

  /**
   * ʹjdkиڹ
   */
  private BSCalendar(Calendar calendar)
  {
    this.calendar = calendar;
  }

  /**
   * õ
   * @return 
   */
  public int getYear()
  {
    return this.calendar.get(Calendar.YEAR);
  }

  /**
   * ѵǰµָ
   */
  public void setYear(int year)
  {
    this.calendar.set(year, this.getMonth() - 1, this.getDay());
  }

  /**
   * õ
   * @return 
   */
  public int getDay()
  {
    return this.calendar.get(Calendar.DATE);
  }

  /**
   * õ·
   * @return ·
   */
  public int getMonth()
  {
    return this.calendar.get(Calendar.MONTH) + 1;
  }

  /**
   * ѵǰ·ݸµָ·
   */
  public void setMonth(int month)
  {
    this.calendar.set(this.getYear(), month - 1, this.getDay());
  }

  /**
   * ѵǰµָ
   */
  public void setDay(int day)
  {
    this.calendar.set(this.getYear(), this.getMonth() - 1, day);
  }

  /**
   * Сʱ
   * һ24Сʱ
   */
  public void setHour(int hour)
  {
    this.calendar.set(this.getYear(), this.getMonth() - 1, this.getDay(), hour,
        this.getMinute());
  }

  /**
   * õСʱ
   * @return Сʱ һ24Сʱ
   */
  public int getHour()
  {
    return this.calendar.get(Calendar.HOUR_OF_DAY);
  }

  /**
   * õ
   * @return 
   */
  public int getMinute()
  {
    return this.calendar.get(Calendar.MINUTE);
  }

  /**
   * ·
   */
  public void setMinute(int minute)
  {
    this.calendar.set(this.getYear(), this.getMonth() - 1, this.getDay(), this.getHour(),
        minute);
  }

  /**
   * ֮
   * @param other Ҫ
   * @return 
   */
  public int getMonthDispersion(BSCalendar other)
  {
    //ڻɾ·
    int month1 = this.getYear() * 12 + this.getMonth();
    int month2 = other.getYear() * 12 + other.getMonth();
    //ؾ·ݵĲֵ
    return month1 - month2;
  }

  /**
   * ֮
   * @param other Ҫ
   * @return 
   */
  public int getYearDispersion(BSCalendar other)
  {
    //ڶӦĲֵ
    return this.getYear() - other.getYear();
  }

  /**
   * ֮
   */
  public int getDayDispersion(BSCalendar other)
  {
    //õӦľ
    long time1 = this.getTime();
    int day1 = (int) (time1 / (24 * 60 * 60 * 1000));
    long time2 = other.getTime();
    int day2 = (int) (time2 / (24 * 60 * 60 * 1000));
    //Ӧľֵ
    return day1 - day2;
  }

  /**
   * õԺʱ
   * @return Ժʱ
   */
  public long getTime()
  {
    return this.calendar.getTimeInMillis();
  }

  /**
   * õԵǰǰ
   */
  public BSCalendar getCalendarAfterDay(int day)
  {
    //Ƶǰ
    BSCalendar result = (BSCalendar)this.clone();
    //ǰƶ
    result.calendar.add(Calendar.DATE, day);
    return result;
  }

  /**
   * õԵǰǰµ
   */
  public BSCalendar getCalendarAfterMonth(int month)
  {
    //Ƶǰ
    BSCalendar result = (BSCalendar)this.clone();
    //ǰƶ
    result.calendar.add(Calendar.MONTH, month);
    return result;
  }

  /**
   * õԵǰǰ
   */
  public BSCalendar getCalendarAfterYear(int year)
  {
    //Ƶǰ
    BSCalendar result = (BSCalendar)this.clone();
    //ǰƶ
    result.calendar.add(Calendar.YEAR, year);
    return result;
  }

  /**
   * תɹ̶ʽַַʽΪyyyy-mm-dd
   */
  public String toString()
  {
    //õ
    int year = this.calendar.get(Calendar.YEAR);
    int month = this.calendar.get(Calendar.MONTH) + 1;
    int day = this.calendar.get(Calendar.DAY_OF_MONTH);
    //תɴ
    String strMonth = Integer.toString(month + 100);
    String strDay = Integer.toString(day + 100);
    String result = Integer.toString(year) + strMonth.substring(1) + strDay.substring(1);
    return result;
  }

  /**
   * תɲͬʽַַʽΪformat
   * """yyyy(YYYY)"ʾ;"""mm(MM)"ʾ;"""dd(DD)";
   * "Сʱ""hh(HH)"ʾӡ"tt(TT)"ʾӡ"ss(SS)"ʾ yyyyyyʾλʾ
   * mmmʾС£0-9ǰ治㣻 dddʾСգ0-9ǰ
   * """cw(CW)"ʾ;"Ӣ""ew(EW)"ʾ ʽʱĬϸʽΪ "yyyymmdd" ʾ:"20050202"
   * ʽ1"yyyymmdd" ʾ磺 "20050202" ʽ2"yyyymmdd cw"
   * ʾ磺"20050202 " ʽ3: " yyyy-mm-dd ew" ʾ:"2005-02-02 Wednesday"
   * ʽ4: "yymmdd" ʾ:"050202 "
   */
  public String toString(String format)
  {
    String result = null;
    format = format.toUpperCase();
    // õ
    int year = this.calendar.get(Calendar.YEAR);
    int month = this.calendar.get(Calendar.MONTH) + 1;
    int day = this.calendar.get(Calendar.DAY_OF_MONTH);
    int weekday = this.calendar.get(Calendar.DAY_OF_WEEK) - 1;
    // õСʱӡ
    int hour = this.getHour();
    int minute = this.getMinute();
    int second = this.getSceond();
    // תɴ
    // 滻ʽе
    format = getYearInFormat(format, year);
    // 滻ʽе
    format = getMonthInFormat(format, month);
    // 滻ʽе
    format = getDayInFormat(format, day);
    // 滻ʽеСʱ
    format = getHourInFormat(format, hour);
    // 滻ʽеķ
    format = getMinuteInFormat(format, minute);
    // 滻ʽе
    format = getSecondInFormat(format, second);
    // 滻ʽеڼ
    result = getWeekDayInFormat(format, weekday);
    return result;
  }

  /**
   * ʽе
   *
   * @param format
   *            ʾʽ
   * @param year
   * @return 滻Ժĸʽ
   */
  private String getYearInFormat(String format, int year)
  {
    String result = null;
    // 滻λʾ
    String longyear = Integer.toString(year);
    format = format.replaceAll("YYYY", longyear);
    // 滻λʾ
    String shortyear = longyear.substring(2);
    result = format.replaceAll("YY", shortyear);
    return result;
  }

  /**
   * ʽе
   *
   * @param format
   *            ʾʽ
   * @param month
   * @return 滻Ժĸʽ
   */
  private String getMonthInFormat(String format, int month)
  {
    String result = null;
    // õ·ݵλʾʽ
    String longMonth = Integer.toString(100 + month);
    longMonth = longMonth.substring(1);
    // 滻λʾ·
    format = format.replaceAll("MM", longMonth);
    // 滻һλʾ·
    result = format.replaceAll("M", Integer.toString(month));
    return result;
  }

  /**
   * ʽе
   *
   * @param format
   *            ʾʽ
   * @param day
   * @return 滻Ժĸʽ
   */
  private String getDayInFormat(String format, int day)
  {
    String result = null;
    // õ·ݵλʾʽ
    String longday = Integer.toString(100 + day);
    longday = longday.substring(1);
    // 滻λʾ
    format = format.replaceAll("DD", longday);
    // 滻һλʾ
    result = format.replaceAll("D", Integer.toString(day));
    return result;
  }

  /**
   * ʽе
   *
   * @param format
   *            ʾʽ
   * @param weekdayDay_Of_Weekķֵ
   * @return 滻Ժĸʽ
   */
  private String getWeekDayInFormat(String format, int weekday)
  {
    String result = null;
    // 滻ڼ
    format = format.replaceAll("CW", this.getChinaDayOfWeek(weekday));
    // 滻Ӣڼ
    result = format.replaceAll("EW", this.getEnglishDayOfWeek(weekday));
    return result;
  }

  /**
   * ʽеСʱ
   *
   * @param format
   *            ʾʽ
   * @param hourhourķֵ
   * @return 滻СʱԺĸʽ
   */
  private String getHourInFormat(String format, int hour)
  {
    String result = null;
    // õ·ݵλʾʽ
    String longday = Integer.toString(100 + hour);
    longday = longday.substring(1);
    // 滻λʾ
    format = format.replaceAll("HH", longday);
    // 滻һλʾ
    result = format.replaceAll("H", Integer.toString(hour));
    return result;
  }

  /**
   * ʽеķ
   *
   * @param format
   *            ʾʽ
   * @param minuteminuteķֵ
   * @return 滻Ժĸʽ
   */
  private String getMinuteInFormat(String format, int minute)
  {
    String result = null;
    // õ·ݵλʾʽ
    String longday = Integer.toString(100 + minute);
    longday = longday.substring(1);
    // 滻λʾ
    format = format.replaceAll("TT", longday);
    // 滻һλʾ
    result = format.replaceAll("T", Integer.toString(minute));
    return result;
  }

  /**
   * 滻ʽе
   */
  private String getSecondInFormat(String format, int second)
  {
    String result = "";
    // õ·ݵλʾʽ
    String longday = Integer.toString(100 + second);
    longday = longday.substring(1);
    // 滻λʾ
    format = format.replaceAll("SS", longday);
    // 滻һλʾ
    result = format.replaceAll("S", Integer.toString(second));
    return result;
  }

  /**
   * õ
   */
  public int getSceond()
  {
    return this.calendar.get(Calendar.SECOND);
  }

  /**
   * ĵڼ
   *
   * @param myweekday
   *            :Calendar.DAY_OF_WEEKķֵ
   * @return ĵڼ
   */
  public String getChinaDayOfWeek(int myweekday)
  {
    String weekday = null;
    if (myweekday == 0)
    {
      weekday = "  ";
    }
    else if (myweekday == 1)
    {
      weekday = " һ ";
    }
    else if (myweekday == 2)
    {
      weekday = " ڶ ";
    }
    else if (myweekday == 3)
    {
      weekday = "  ";
    }
    else if (myweekday == 4)
    {
      weekday = "  ";
    }
    else if (myweekday == 5)
    {
      weekday = "  ";
    }
    else if (myweekday == 6)
    {
      weekday = "  ";
    }
    return weekday;
  }

  /**
   * Ӣĵڼ
   *
   * @param myweekday
   *            :Calendar.DAY_OF_WEEKķֵ
   * @return Ӣĵڼ
   */
  public String getEnglishDayOfWeek(int myweekday)
  {
    String weekday = null;
    if (myweekday == 0)
    {
      weekday = " Sunday ";
    }
    else if (myweekday == 1)
    {
      weekday = " Monday ";
    }
    else if (myweekday == 2)
    {
      weekday = " Tuesday ";
    }
    else if (myweekday == 3)
    {
      weekday = " Wednesday ";
    }
    else if (myweekday == 4)
    {
      weekday = " Thursday ";
    }
    else if (myweekday == 5)
    {
      weekday = " Friday ";
    }
    else if (myweekday == 6)
    {
      weekday = " Saturday ";
    }
    return weekday;
  }
}