select ma.month,
isnull(ma.monthtotal,0) monthtotal,
isnull(mz.monthnormal,0) monthnormal,
isnull(my.monthdefect,0) monthdefect,
isnull(mr.monthruhu,0) monthruhu,
isnull(md.monthdfby,0) monthdfby,
ISNULL(mmy.monthmy,0) monthmy,
ISNULL(mfmy.monthfmy,0) monthfmy
from
(
  select
    SUBSTRING(f_offsite_time,0,8) month,
    COUNT(id) monthtotal from (
      select * from (
        select *,ROW_NUMBER() over(partition by f_checker_name,f_userinfoid order by f_offsite_time desc)as lastcheck
        from (select * from t_check_paper ) tp) t
        where lastcheck=1
    )t
    where SUBSTRING(f_offsite_time,0,8) = SUBSTRING(CONVERT(varchar,GETDATE(),23),0,8)
   group by SUBSTRING(f_offsite_time,0,8)
) ma
left join
(
  select
    SUBSTRING(f_offsite_time,0,8) month,
    COUNT(id) monthnormal from (
      select * from (
        select *,ROW_NUMBER() over(partition by f_checker_name,f_userinfoid order by f_offsite_time desc)as lastcheck
        from (select * from t_check_paper) tp) t
        where lastcheck=1
    )t
    where SUBSTRING(f_offsite_time,0,8) = SUBSTRING(CONVERT(varchar,GETDATE(),23),0,8)
    and CHARINDEX('正常',f_defect_content) !=0
   group by SUBSTRING(f_offsite_time,0,8)
) mz
on ma.month = mz.month
left join
(
  select
    SUBSTRING(f_offsite_time,0,8) month,
    COUNT(id) monthdefect from (
      select * from (
        select *,ROW_NUMBER() over(partition by f_checker_name,f_userinfoid order by f_offsite_time desc)as lastcheck
        from (select * from t_check_paper) tp) t
        where lastcheck=1
    )t
    where SUBSTRING(f_offsite_time,0,8) = SUBSTRING(CONVERT(varchar,GETDATE(),23),0,8)
    and CHARINDEX('有隐患',f_defect_content) !=0
   group by SUBSTRING(f_offsite_time,0,8)
) my
on my.month = ma.month
left join
(
  select
    SUBSTRING(f_offsite_time,0,8) month,
    COUNT(id) monthruhu from (
      select * from (
        select *,ROW_NUMBER() over(partition by f_checker_name,f_userinfoid order by f_offsite_time desc)as lastcheck
        from (select * from t_check_paper) tp) t
        where lastcheck=1
    )t
    where SUBSTRING(f_offsite_time,0,8) = SUBSTRING(CONVERT(varchar,GETDATE(),23),0,8)
    and f_entry_status = '入户'
   group by SUBSTRING(f_offsite_time,0,8)
) mr
on mr.month = ma.month
left join
(
  select
    SUBSTRING(f_offsite_time,0,8) month,
    COUNT(id) monthdfby from (
      select * from (
        select *,ROW_NUMBER() over(partition by f_checker_name,f_userinfoid order by f_offsite_time desc)as lastcheck
        from (select * from t_check_paper) tp) t
        where lastcheck=1
    )t
    where SUBSTRING(f_offsite_time,0,8) = SUBSTRING(CONVERT(varchar,GETDATE(),23),0,8)
    and f_entry_status = '到访不遇'
   group by SUBSTRING(f_offsite_time,0,8)
) md
on md.month = ma.month
left join
(
  select
    SUBSTRING(f_offsite_time,0,8) month,
    COUNT(id) monthmy from (
      select * from (
        select *,ROW_NUMBER() over(partition by f_checker_name,f_userinfoid order by f_offsite_time desc)as lastcheck
        from (select * from t_check_paper) tp) t
        where lastcheck=1
    )t
    where SUBSTRING(f_offsite_time,0,8) = SUBSTRING(CONVERT(varchar,GETDATE(),23),0,8)
    and f_check_type = '民用'
   group by SUBSTRING(f_offsite_time,0,8)
)mmy
on mmy.month = ma.month
left join
(
  select
    SUBSTRING(f_offsite_time,0,8) month,
    COUNT(id) monthfmy from (
      select * from (
        select *,ROW_NUMBER() over(partition by f_checker_name,f_userinfoid order by f_offsite_time desc)as lastcheck
        from (select * from t_check_paper) tp) t
        where lastcheck=1
    )t
    where SUBSTRING(f_offsite_time,0,8) = SUBSTRING(CONVERT(varchar,GETDATE(),23),0,8)
    and f_check_type = '非民用'
   group by SUBSTRING(f_offsite_time,0,8)
)mfmy
on mfmy.month = ma.month