select
	uf.f_meternumber, --燃气表号
	uf.f_aroundmeter, --左右表
	uf.f_valve_state f_uf_valve_state, -- 表档案阀门状态
    case mr.f_valveState when '0' then '开阀' else '关阀' end f_valve_state, -- 抄表返回的阀门状态
	gb.f_meter_brand, --燃气表品牌
	gb.f_meter_type, --燃气表类型
	ui.f_userinfo_code, --用户编号
	ui.f_user_name, --用户姓名
	ui.f_user_phone, --用户电话
	uf.f_user_type, --用户类型
	ua.f_address, --用户地址
	uf.f_meter_base, --气表底数
	uf.f_total_gas, --累计气量
	uf.f_total_fee, --累计金额
	mr.f_batteryLevel2, --碱电电压
	mr.f_jval as f_balance_amount--预存余额
from
t_userfiles uf
LEFT JOIN t_gasbrand gb on uf.f_gasbrand_id = gb.id
LEFT JOIN t_userinfo  ui on uf.f_userinfo_id = ui.f_userinfo_id
LEFT JOIN t_user_address ua on uf.f_userinfo_id = ua.f_userinfo_id
left join (SELECT *, ROW_NUMBER () OVER ( PARTITION BY f_meternumber ORDER BY f_hand_date DESC ) rn FROM t_meteread) mr on uf.f_meternumber = mr.f_meternumber
where rn = 1 and { condition } and uf.f_table_state = '正常' and gb.f_meter_type = '物联网表'
order by uf.f_meternumber
