SELECT 
	*
FROM (
	SELECT 
		*,
		(
			CASE f_defect_count
				WHEN 0
					THEN '无隐患'
				ELSE '有隐患'
			END
		) f_has_defect,
		(
			CASE f_repair_count
				WHEN 0
					THEN '隐患已处理'
				ELSE '有隐患'
			END
		) f_is_repair
	FROM (
		SELECT
			cp.id,
			cp.f_entry_status,
			cp.f_userinfo_code,
			cp.f_user_name,
			cp.f_onsite_time,
			cp.f_offsite_time,
			cp.f_checker_name,
			ua.f_address,
			cp.f_check_plan_id,
			cpl.f_plan_name,
			ui.f_userinfo_id,
			ui.f_filialeid,
			(
				SELECT
					SUM(
						CASE di.f_is_defect
							WHEN 'true' 
								THEN 1
							ELSE 0
						END
					) f_defect_count
				FROM
					t_paper_devices pd 
					LEFT JOIN t_devices_items di ON di.f_device_id = pd.id
				WHERE
					pd.f_paper_id = cp.id
			)
			f_defect_count,
			(
			SELECT
				SUM(
					CASE
						WHEN di.f_is_defect != 'true' THEN 0
						WHEN di.f_is_defect = 'true' AND ( di.f_is_repaired = '已处理' OR di.f_user_changes = '是' OR di.f_live_dispose = '是' )
							THEN 0
						ELSE 1
					END
				) f_repair_count
				FROM
					t_paper_devices pd 
					LEFT JOIN t_devices_items di ON di.f_device_id = pd.id
				WHERE
					pd.f_paper_id = cp.id
			)
			f_repair_count
		FROM
			t_check_paper cp
			LEFT JOIN t_check_plan cpl ON cpl.id = cp.f_check_plan_id
			LEFT JOIN t_userinfo ui ON ui.f_userinfo_id = cp.f_userinfoid
			LEFT JOIN t_user_address ua ON ua.f_userinfo_id = cp.f_userinfoid
		WHERE
			ui.f_user_state  = '正常'
			AND ui.f_filialeid in {f_filialeids}
	) t_temp
) t_temp2
WHERE 
	{condition}
ORDER BY
	f_offsite_time