{
__n__ == $__n__$ :
$
	with rcq AS
	(
		select id, name, parentid, ename from (
			select name, id, parentid, '' ename from t_organization
			union all
			select name, id, parentid, ename from t_user) t where  t.id = {org_id}
		UNION ALL
		select a.id id, a.name name, a.parentid parentid, a.ename ename from (
			select name, id, parentid, '' ename from t_organization
			union all
			select name, id, parentid, ename from t_user) a
		INNER JOIN rcq s on s.id = a.parentid
	)
	
	select {f_aggregations} from (
		select distinct f_repairman from t_check_paper where 
		{
			f_subcompany != $$ :
			$
				f_subcompany='{f_subcompany}' and 
			$,
			$
			$
		}
		 f_repairman is not null and f_repairman in (select name from rcq where ename != '') 
		and f_repair_date >= '{f_plan_year}-01-01' and f_repair_date <= '{f_plan_year}-12-31 23:59:59'
	) t
$,
$
	with rcq AS
	(
		select id, name, parentid, ename from (
			select name, id, parentid, '' ename from t_organization
			union all
			select name, id, parentid, ename from t_user) t where  t.id = {org_id}
		UNION ALL
		select a.id id, a.name name, a.parentid parentid, a.ename ename from (
			select name, id, parentid, '' ename from t_organization
			union all
			select name, id, parentid, ename from t_user) a
		INNER JOIN rcq s on s.id = a.parentid
	)
	select * from (
		select *, ROW_NUMBER() OVER (ORDER BY f_repairman) AS rownum from (
			select f_repairman, 
			sum(case when f_repaired='已修' then 1 else 0 end) checked, sum(case when f_repaired='在修' then 1 else 0 end) checking, 
			sum(case when f_repaired= '已修' then 0 when f_repaired='在修' then 0 else 1 end) unchecked from t_check_paper 
			where 
			{
				f_subcompany != $$ :
				$
					f_subcompany='{f_subcompany}' and 
				$,
				$
				$
			}
			 f_repairman is not null and f_repairman in (select name from rcq where ename != '') 
			and f_repair_date >= '{f_plan_year}-01-01' and f_repair_date <= '{f_plan_year}-12-31 23:59:59'
			and f_approved='已审核'
			group by f_repairman
		) t 
	) tt where rownum between {__startRow__} and {__endRow__} 
$
}