//获取安检隐患分布情况 各种类型隐患数量和占比数据
SELECT
    yhlevel,     -- 隐患等级
    f_item_name, --隐患名称
    COUNT ( 0 ) AS defect_num, --隐患数
    SUM ( aa ) + SUM ( bb ) AS  processed, --已处理
    SUM ( cc ) AS processed_two --未处理
FROM
    (
        SELECT
            case when f_defect_level like '一级%' then '一级隐患' when f_defect_level like '二级%' then '二级隐患' when f_defect_level like '三级%' or f_item_name='气量异常差值' then '三级隐患' else '未定级隐患' end as  yhlevel,
            tdi.f_item_name,
            CASE

                WHEN f_live_dispose = '是' THEN
                    1 ELSE 0
                END AS aa,
            CASE

                WHEN f_is_repaired = '已处理' THEN
                    1 ELSE 0
                END AS bb,
            CASE

                WHEN ( f_is_repaired != '已处理' OR f_is_repaired IS NULL )
                    AND ( f_live_dispose != '是' OR f_live_dispose IS NULL ) THEN
                    1 ELSE 0
                END AS cc
        FROM
            t_check_paper tcp with (nolock )
                LEFT JOIN t_paper_devices tpd  with (nolock ) ON tcp.id= tpd.f_paper_id
                LEFT JOIN t_devices_items tdi with (nolock )  ON tpd.id= tdi.f_device_id
        WHERE
                tdi.f_is_defect = 'true' and tcp.f_upload_date>'{start_date}' and tcp.f_upload_date<'{end_date}'
            {
            f_filialeid != $$: $ and {f_filialeid} $,$$
            }
            {
            f_user_type != $$:
            $  and tcp.f_check_type = '{f_user_type}'$,$$
            }

            {
            defect_level != $$:
            $  and {defect_level}$,$$
            }
    ) tt
GROUP BY
    yhlevel,
    f_item_name
ORDER BY
    yhlevel,
    f_item_name
