SELECT
	*
FROM (
	SELECT
		t_temp.*,f_meter_book_num,f_slice_area,
		(
			CASE f_defect_count
				WHEN 0
					THEN '无隐患'
				ELSE '有隐患'
			END
		) f_has_defect,
		(
			CASE f_repair_count
				WHEN 0
					THEN '隐患已处理'
				ELSE '有隐患'
			END
		) f_is_repair
	FROM (
		SELECT
			cp.id,
			cp.f_entry_status,
			cp.f_residential_area,
            cp.f_user_phone,
			cp.f_userinfo_code,
			cp.f_user_name,
            {entity.findDialect() == $SqlServer$:$ f_offsite_time $,$ to_date(f_offsite_time,'yyyy-mm-dd hh24:mi:ss') f_offsite_time $},
            {entity.findDialect() == $SqlServer$:$ f_onsite_time $,$ to_date(f_onsite_time,'yyyy-mm-dd hh24:mi:ss') f_onsite_time $},
			cp.f_checker_name,
			ua.f_address,
			cp.f_check_plan_id,
			cpl.f_plan_name,
			ui.f_userinfo_id,
			ui.f_filialeid,
			cp.f_repaired,
			CASE WHEN instr(f_defect_content,'正常') > 0 THEN '无隐患' ELSE '有隐患' end f_defect_content,
			(
				SELECT
					SUM(
						CASE di.f_is_defect
							WHEN 'true'
								THEN 1
							ELSE 0
						END
					) f_defect_count
				FROM
					t_paper_devices pd {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $}
					LEFT JOIN t_devices_items di  {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $}  ON di.f_device_id = pd.id
				WHERE
					pd.f_paper_id = cp.id
			)
			f_defect_count,
			(
			SELECT
				SUM(
					CASE
						WHEN dl.f_dealwith is null THEN 0

						ELSE 1
					END
				) f_repair_count
				FROM
					t_paper_devices pd {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $}
					LEFT JOIN t_devices_items di  {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $} ON di.f_device_id = pd.id
					LEFT JOIN t_devices_items_lists dl  {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $} ON dl.f_item_id = di.id

				WHERE
					pd.f_paper_id = cp.id
			)
			f_repair_count
		FROM
			t_check_paper cp {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $}
			LEFT JOIN t_check_plan cpl {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $} ON cpl.id = cp.f_check_plan_id
			LEFT JOIN t_userinfo ui {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $} ON ui.f_userinfo_id = cp.f_userinfoid
			LEFT JOIN t_user_address ua {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $} ON ua.f_userinfo_id = cp.f_userinfoid
		WHERE
			ui.f_user_state  = '正常'
	) t_temp
left join t_userfiles tu {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $}  on t_temp.f_userinfo_id=tu.f_userinfo_id
left join t_user_address tud {entity.findDialect() == $SqlServer$:$ with(nolock) $,$ $}  on t_temp.f_userinfo_id=tud.f_userinfo_id

) t_temp2
WHERE
	{condition}
ORDER BY
	f_offsite_time
