Declare @inGroupID   nvarchar(50)
Declare @inStartDate varchar(50)
Declare @inEndDate   varchar(50)
Set @inStartDate = '{startDate}'
Set @inEndDate = '{endDate}'
Set @inGroupID = 'XYGAS'

Declare @TempTable Table
                   (
                       FaultType         nvarchar(50),
                       FaultTypeName     nvarchar(50),
                       EquipmentType     nvarchar(50),
                       EquipmentTypeName nvarchar(50),
                       FaultGrade        nvarchar(50)
                   )

Delete
from @TempTable

    Insert into @TempTable
Select FaultType, FaultTypeName, PL.EquipmentType, EquipmentTypeName, FaultGrade
from FaultList PL
         Inner Join Bas_Employee As BE on BE.EmployeeID = Reporter
         Inner Join dbo.fn_GetGroupTree(@inGroupID) As Tree on Tree.GroupID = BE.DeptID
Where (PL.CreateDate Between CONVERT(datetime, @inStartDate + ' 00:00:00') And CONVERT(datetime, @inEndDate + ' 23:59:59'))
  and isnull(FaultTypeName, '') <> ''
  AND PL.[State] <> '-1'
  AND PL.[State] <> '3'
Declare @AllTable Table
                  (
                      FaultTypeName nvarchar(50),
                      TypeCount     int
                  )
Delete
from @AllTable

    Insert into @AllTable
Select LTRIM(RTRIM(FaultTypeName)), COUNT(*)
from @TempTable
Group by LTRIM(RTRIM(FaultTypeName))
order by LTRIM(RTRIM(FaultTypeName))

Declare @AllCount int
Select @AllCount = SUM(TypeCount)
from @AllTable

Declare @SubTable Table
                  (
                      FaultTypeName nvarchar(50),
                      subCount      int
                  )
Delete
from @SubTable

    Insert into @SubTable
Select LTRIM(RTRIM(FaultTypeName)), COUNT(*)
from @TempTable
Group by LTRIM(RTRIM(FaultTypeName))
order by LTRIM(RTRIM(FaultTypeName))

Select row_number() over (order by a.FaultTypeName )                                                          as number,
        a.FaultTypeName,
       t.cRowCount,
       a.TypeCount,
       s.subCount,
       @AllCount                                                                                              As AllCount,
       (case
            when a.FaultTypeName = '' then
                    Convert(varchar(10), Convert(decimal(10, 2), s.subCount * 1.0 / a.TypeCount * 100)) + '%'
            else Convert(varchar(10), Convert(decimal(10, 2), s.subCount * 1.0 / @AllCount * 100)) +
                 '%' end)                                                                                     as percentage
from @AllTable a
         Inner join @SubTable s on s.FaultTypeName = a.FaultTypeName
         Inner Join (Select a.FaultTypeName, COUNT(*) as cRowCount
                     from @AllTable a
                              Inner join @SubTable s on s.FaultTypeName = a.FaultTypeName
                     Group by a.FaultTypeName
) t on t.FaultTypeName = a.FaultTypeName
order by a.FaultTypeName
