SELECT
    *
FROM
    (
        SELECT
            tcp.f_userinfo_code,
            tcp.f_user_name,
            tcp.f_user_phone,
            tcp.f_residential_area,
            tcp.f_address,
            tcp.f_checker_name,
            tcp.f_offsite_time,
            tcp.f_filialeid,
            tcp.f_check_type,
            tpd.f_device_type,
            tdi.f_item_name,
            tdil.f_item_value,
            tdil.f_dealpath,
            tdil.f_deal_remark,
            tdil.f_dealer_starttime,
            tdil.f_dealer_endtime,
            tdil.f_dealer_name,
            uf.f_meternumber,
            uf.f_aroundmeter,
            tdil.f_dealsign_path,
            CASE

                WHEN tdi.f_defect_level IS NULL
                    OR tdi.f_defect_level= '' THEN
                    '未定级' ELSE tdi.f_defect_level
                END f_defect_level,
            CASE

                WHEN tdi.f_is_repaired IS NULL THEN
                    '未处理' ELSE tdi.f_is_repaired
                END f_is_repaired,
            CASE

                WHEN tdi.f_repairman IS NULL THEN
                    '***' ELSE tdi.f_repairman
                END f_repairman,
            CASE

                WHEN tdi.f_repair_date IS NULL THEN
                    '****-**-** **:**:**' ELSE tdi.f_repair_date
                END f_repair_date
        FROM
            t_check_paper tcp
                LEFT JOIN t_userfiles uf on tcp.f_userinfoid=uf.f_userinfo_id
                LEFT JOIN t_paper_devices tpd ON tcp.id= tpd.f_paper_id
                LEFT JOIN t_devices_items tdi ON tpd.id= tdi.f_device_id
                LEFT JOIN t_devices_items_lists tdil ON tdil.f_item_id= tdi.id
        WHERE
                tdi.f_is_defect = 'true' and { condition }
    ) tt
ORDER BY
    f_offsite_time DESC
