--根据年份查出月计划项数目
 select
f_checker,
f_checker_id,
COUNT(1) AS plannum,
SUM(isnull(wrj,0)) AS wrj,
SUM(isnull(yrj,0)) AS yrj,
SUM(isnull(ruhu,0)) AS ruhu,
SUM(isnull(daofang,0)) AS daofang,
SUM(isnull(jujian,0)) AS jujian,
SUM(isnull(wuruhu,0)) AS wuruhu,
SUM(isnull(wujujian,0)) AS wujujian,
SUM(isnull(wudaofang,0)) AS wudaofang
   from (
    SELECT
    tcp.f_checker,
    tcp.f_checker_id,
    CASE
        WHEN tcpi.f_state = '未检' or (tcpi.f_state = '已检' and tcpi.F_LAST_CHECK_STATE != '入户')
        THEN 1
        ELSE 0
    END AS wrj,
    CASE
        WHEN tcpi.f_state = '已检' and tcpi.F_LAST_CHECK_STATE = '入户'
        THEN 1
        ELSE 0
    END AS yrj,
    ruhu,daofang,jujian,wuruhu,wujujian,wudaofang
     FROM (select * from t_check_plan where f_filialeid in {f_filialeids}) tcp
     left JOIN (select * from  t_check_plan_item where f_filialeid in {f_filialeids} ) tcpi ON tcp.id = tcpi.f_plan_id
     left join (
		select  a.*,
               CASE
                   WHEN f_entry_status = '入户'
                        AND F_NO_CHECKPLAN = '有计划安检'
                   THEN 1
                   ELSE 0
               END AS ruhu,
               CASE
                   WHEN f_entry_status = '到访不遇'
                        AND F_NO_CHECKPLAN = '有计划安检'
                   THEN 1
                   ELSE 0
               END AS daofang,
               CASE
                   WHEN f_entry_status = '拒检'
                        AND F_NO_CHECKPLAN = '有计划安检'
                   THEN 1
                   ELSE 0
               END AS jujian,
                CASE
                    WHEN f_entry_status = '入户'
                        AND F_NO_CHECKPLAN = '无计划安检'
                        THEN 1
                    ELSE 0
                    END AS wuruhu,
                CASE
                    WHEN f_entry_status = '拒检'
                        AND F_NO_CHECKPLAN = '无计划安检'
                        THEN 1
                    ELSE 0
                    END AS wujujian,
                CASE
                    WHEN f_entry_status = '到访不遇'
                        AND F_NO_CHECKPLAN = '无计划安检'
                        THEN 1
                    ELSE 0
                    END AS wudaofang
		from t_check_paper a
		inner join
		(
			select f_check_item_id,max(f_upload_date) upload_time
			from t_check_paper group by f_check_item_id
		) b on a.f_check_item_id=b.f_check_item_id and b.upload_time=a.f_upload_date
		WHERE f_filialeid in {f_filialeids}
            {
                f_start_time == $$ :
                $$,
                $
                 and f_offsite_time >= '{f_start_time}'
                $
            }
            {
                f_end_time == $$ :
                $$,
                $
                 and f_offsite_time <= '{f_end_time}'
                $
            }
    ) tt on tt.f_check_item_id=tcpi.id
    left join t_user usr ON usr.id = tcp.f_checker_id
     where  tcp.f_checker is not null and {condition}
 ) paper
 GROUP BY f_checker_id,f_checker
 order by f_checker
