/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.extra.qrcode.BufferedImageLuminanceSource;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class QRCodeUtil {
    private static final int black = -16777216;
    private static final int white = -1;

    public static String zxingcodecreate(String text, int width, int height, String imagetype) {
        HashMap<EncodeHintType, String> his = new HashMap<EncodeHintType, String>();
        his.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        FastByteArrayOutputStream os = new FastByteArrayOutputStream();
        try {
            BitMatrix encode = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, his);
            int codewidth = encode.getWidth();
            int codeheight = encode.getHeight();
            BufferedImage image = new BufferedImage(codewidth, codeheight, 1);
            for (int i = 0; i < codewidth; ++i) {
                for (int j = 0; j < codeheight; ++j) {
                    image.setRGB(i, j, encode.get(i, j) ? -16777216 : -1);
                }
            }
            ImageIO.write((RenderedImage)image, imagetype, (OutputStream)os);
        }
        catch (WriterException e) {
            e.printStackTrace();
            System.out.println("\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("\u751f\u6210\u4e8c\u7ef4\u7801\u56fe\u7247\u5931\u8d25");
        }
        return Base64.getEncoder().encodeToString(os.toByteArray());
    }

    public static Object zxingcodeanalyze(String analyzepath) throws Exception {
        MultiFormatReader formatReader = new MultiFormatReader();
        Result result = null;
        try {
            File file = new File(analyzepath);
            if (!file.exists()) {
                return "\u4e8c\u7ef4\u7801\u4e0d\u5b58\u5728";
            }
            BufferedImage image = ImageIO.read(file);
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            result = formatReader.decode(binaryBitmap, hints);
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        return result;
    }
}

