package com.aote.util;

import com.af.plugins.DateTools;
import com.aote.config.SystemConfig;
import com.aote.util.other.Base64Utils;
import sun.misc.BASE64Encoder;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class Base64Util {
    // 保存文件
    public static String saveImage(String rootDir, String data, String filename) {
        File dir = new File(rootDir + File.separator + DateTools.getNow("yyyy-MM-dd"));
        FileOutputStream fop = null;
        File file = null;
        if (!dir.exists()) {
            dir.mkdir();
        }
        try {
            file = new File(dir.getAbsolutePath() + File.separator + DateTools.getNow("yyyy_MM_dd_hh_mm_ss") + filename);
            fop = new FileOutputStream(file);
            byte[] content = Base64Utils.decodeBuffer(data.split(",")[1]);
            fop.write(content);
            fop.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return file.getAbsolutePath();
    }

    public String toBase64(String imgUrl) {
        if (!imgUrl.startsWith("http")){
            imgUrl = SystemConfig.System.getProxyUrl() + imgUrl;
        }

        URL url = null;
        InputStream is = null;
        ByteArrayOutputStream outStream = null;
        HttpURLConnection httpUrl = null;
        try {
            url = new URL(imgUrl);
            httpUrl = (HttpURLConnection) url.openConnection();
            httpUrl.connect();
            httpUrl.getInputStream();
            is = httpUrl.getInputStream();

            outStream = new ByteArrayOutputStream();
            //创建一个Buffer字符串
            byte[] buffer = new byte[1024];
            //每次读取的字符串长度，如果为-1，代表全部读取完毕
            int len = 0;
            //使用一个输入流从buffer里把数据读取出来
            while ((len = is.read(buffer)) != -1) {
                //用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
                outStream.write(buffer, 0, len);
            }
            // 对字节数组Base64编码
            return new BASE64Encoder().encode(outStream.toByteArray());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpUrl != null) {
                httpUrl.disconnect();
            }
        }
        return imgUrl;
    }
}
