package com.aote.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;



/**
 * 张俊杰
 */
public class LocationFileJsonUpload {
    static Logger log = Logger.getLogger(LocationFileJsonUpload.class);

    public LocationFileJsonUpload() {
    }

    public static String uploadDataToJsonFile(JSONArray dataJson) {
        Writer write = null;
        String context = dataJson.toString();
        String filePath = null;

        Object var5;
        try {
            filePath = getPath("uploadDataToJsonFilePath");
            filePath = getRealPath(filePath) + File.separator + UUID.randomUUID().toString().replace("-", "") + ".json";
            log.info("将定位数据转为JSON保存到文件夹的位置为" + filePath);
            File fileFile = new File(filePath);
            if (!fileFile.getParentFile().exists()) {
                fileFile.getParentFile().mkdirs();
            }

            fileFile.createNewFile();
            write = new OutputStreamWriter(new FileOutputStream(fileFile), "UTF-8");
            write.write(context);
            return filePath;
        } catch (IOException var15) {
            var15.printStackTrace();
            log.error("IO错误，当前错误来自于com.aote.plugins.LocationFileJsonUpload的uploadDataToJsonFile方法");
            var5 = null;
        } finally {
            try {
                write.flush();
                write.close();
            } catch (IOException var14) {
                var14.printStackTrace();
            }

        }

        return (String)var5;
    }

    public static JSONArray ReadLocationToFileJson(String absolutePath) {
        String laststr = "";
        File file = new File(absolutePath);
        BufferedReader reader = null;
        JSONArray endResult = new JSONArray();

        try {
            FileInputStream in = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));

            for(String tempString = null; (tempString = reader.readLine()) != null; laststr = laststr + tempString) {
            }

            reader.close();
            JSONArray jsonArray = new JSONArray(laststr);

            for(int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                BigDecimal lon = jsonObject.getBigDecimal("lon");
                BigDecimal lat = jsonObject.getBigDecimal("lat");
                endResult.put((new JSONArray()).put(lon).put(lat));
            }
        } catch (IOException var20) {
            var20.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException var19) {
                }
            }

        }

        return endResult;
    }

    public static JSONArray formatUserLocation(JSONArray dataJson) {
        JSONArray jsonArray = new JSONArray();

        for(int i = 0; i < dataJson.length(); i = 0) {
            System.out.println("formatUserLocation的I为：" + i);
            JSONObject object = new JSONObject();
            JSONObject jsonObject = dataJson.getJSONObject(i);
            object.put("f_user_name", jsonObject.getString("f_user_name"));
            object.put("f_user_id", jsonObject.getString("f_user_id"));
            String userid = jsonObject.getString("f_user_id");
            JSONArray tte = new JSONArray();
            int j = 0;

            while(j < dataJson.length()) {
                JSONObject j3 = dataJson.getJSONObject(j);
                if (j3.getString("f_user_id").equals(userid)) {
                    String f_start_date = j3.getString("f_start_date");
                    String f_end_date = j3.getString("f_end_date");
                    String f_user_name = j3.getString("f_user_name");
                    int idds = j3.getInt("id");
                    JSONObject te = (new JSONObject()).put("f_start_date", f_start_date).put("f_end_date", f_end_date).put("f_user_name", f_user_name).put("id", idds);
                    tte.put(te);
                    dataJson.remove(j);
                    j = 0;
                } else {
                    ++j;
                }
            }

            object.put("result", tte);
            jsonArray.put(object);
        }

        return jsonArray;
    }

    private static String getRealPath(String realpath) {
        Date d = new Date();
        realpath = realpath + File.separator + (d.getYear() + 1900) + File.separator + (d.getMonth() + 1) + File.separator + d.getDate();
        File f = new File(realpath);

        try {
            if (!f.exists()) {
                f.mkdirs();
            }

            return realpath;
        } catch (RuntimeException var4) {
            throw var4;
        } catch (Exception var5) {
            throw new RuntimeException(var5);
        }
    }

    private String getNowDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    public static String getPath(String pathname) throws IOException {
        String proPath = System.getProperty("user.dir");
        Properties pro = new Properties();
        FileInputStream in = new FileInputStream(proPath + "/file.properties");
        pro.load(in);
        String path = pro.getProperty(pathname);
        log.info("System.getProperty（”user.dir“）中的 " + pathname + "节点值为" + path);
        in.close();
        return path;
    }
}
