SELECT f_checker,
       plannum,
       case when kabiao is null then 0 else kabiao end   as kabiao,
       case when jujian is null then 0 else jujian end   as jujian,
       case when jibiao is null then 0 else jibiao end   as jibiao,
       case when wlw is null then 0 else jibiao end   as wlw,
       case when ruhu is null then 0 else ruhu end       as ruhu,
       case when daofang is null then 0 else daofang end as daofang,
       case when wuren is null then 0 else wuren end     as wuren
FROM (
         SELECT f_checker,
                COUNT(0) AS plannum
         FROM t_check_plan tcp
                  LEFT JOIN t_check_plan_item tcpi ON tcp.id = tcpi.f_plan_id
         WHERE 1 = 1 {
                f_start_date == $$ :
                $$,
                $
                 and to_date(CAST ( f_plan_year AS VARCHAR ( 10 ) ) || '-' || CAST ( f_plan_month AS VARCHAR ( 10 ) )||'-01 00:00:00','yyyy-mm-dd hh24:mi:ss') >= '{f_start_date}'
                $
            }
            {
                f_end_date == $$ :
                $$,
                $
                 and to_date(CAST ( f_plan_year AS VARCHAR ( 10 ) ) || '-' || CAST ( f_plan_month AS VARCHAR ( 10 ) )||'-01 00:00:00','yyyy-mm-dd hh24:mi:ss') <= '{f_end_date}'
                $
            }
         GROUP BY
             f_checker
     ) t1
         LEFT JOIN (
    SELECT f_checker_name,
           SUM(ruhu)    ruhu,
           SUM(daofang) daofang,
           SUM(jujian)  jujian,
           SUM(jibiao)  jibiao,
           SUM(kabiao)  kabiao,
           SUM(wlw)  wlw,
           SUM(wuren)   wuren
    FROM (
             SELECT CASE

                        WHEN
                            f_entry_status = '入户' THEN
                            1
                        ELSE 0
                        END AS ruhu,
                    CASE

                        WHEN f_entry_status = '到访不遇' THEN
                            1
                        ELSE 0
                        END AS daofang,
                    CASE

                        WHEN f_entry_status = '拒检' THEN
                            1
                        ELSE 0
                        END AS jujian,
                    CASE

                        WHEN f_meter_classify = '机表'
                            AND f_entry_status = '入户' THEN
                            1
                        ELSE 0
                        END AS jibiao,
                    CASE

                        WHEN f_meter_classify LIKE '%卡表%'
                            AND f_entry_status = '入户' THEN
                            1
                        ELSE 0
                        END AS kabiao,
                    CASE

                        WHEN f_meter_classify LIKE '物联网表'
                            AND f_entry_status = '入户' THEN
                            1
                        ELSE 0
                        END AS wlw,
                    CASE

                        WHEN f_safe_nohome = '是' THEN
                            1
                        ELSE 0
                        END AS wuren,
                    f_checker_name
             FROM t_check_paper tcp
                      LEFT JOIN t_userfiles tuf ON tcp.f_userinfoid = tuf.f_userinfo_id
                 AND (f_table_state = '正常' OR f_table_state = '停用')
             WHERE 1 = 1 {
                        f_start_date == $$ :
                        $$,
                        $
                         and to_date(f_upload_date,'yyyy-mm-dd hh24:mi:ss') >= '{f_start_date}'
                        $
                    }
                    {
                        f_end_date == $$ :
                        $$,
                        $
                         and to_date(f_upload_date,'yyyy-mm-dd hh24:mi:ss') <= '{f_end_date}'
                        $
                    }
         ) tt
    GROUP BY f_checker_name
) t2 ON t1.f_checker = t2.f_checker_name
WHERE 1 = 1 {
	f_checker == $$ :
	$$,
	$
	 and f_checker = '{f_checker}'
	$
}
