SELECT
    f_checker_name,
    SUM ( jujian ) + SUM ( ruhu ) + SUM ( daofang ) + SUM ( wwcdaofang ) AS yijian,
    SUM ( ruhu ) + SUM ( daofang ) AS ruhu,
    SUM ( jujian ) AS jujian,
    SUM ( wwcdaofang ) AS daofang,
    CASE

        WHEN ( SUM ( jujian ) + SUM ( ruhu ) + SUM ( daofang ) ) = 0 THEN
            0 ELSE CONVERT (
            NUMERIC ( 19, 2 ),
            ( SUM ( ruhu ) + SUM ( daofang ) ) * 100 / ( SUM ( jujian ) + SUM ( ruhu ) + SUM ( daofang ) + SUM ( wwcdaofang ) )
        )
        END AS ruhulv
FROM
    (
        SELECT
            CASE

                WHEN
                        f_last_check_state = '入户' THEN
                    1 ELSE 0
                END ruhu,
            CASE

                WHEN tcp.f_entry_status= '到访不遇'
                    AND f_last_check_state = '到访不遇' THEN
                    1 ELSE 0
                END daofang,
            CASE

                WHEN tcp.f_entry_status= '拒检'
                    AND f_last_check_state = '拒检' THEN
                    1 ELSE 0
                END jujian,
            CASE

                WHEN tcp.f_entry_status= '到访不遇'
                    AND ( f_last_check_state != '到访不遇' OR f_last_check_state IS NULL ) THEN
                    1 ELSE 0
                END wwcdaofang,
            tcp.*,
            tua.f_last_check_state
        FROM
            (
                SELECT
                    *
                FROM
                    (
                        SELECT
                            f_userinfo_code,
                            id cpid,
                            f_checker_name,
                            f_defect_content,
                            f_checker_id,
                            f_userinfoid,
                            f_upload_date,
                            f_check_item_id,
                            f_onsite_time,
                            f_entry_status,
                            f_safecheck_type,
                            ROW_NUMBER ( ) OVER ( partition BY f_userinfoid ORDER BY f_upload_date DESC ) AS rn
                        FROM
                            t_check_paper
                        WHERE
                                1 = 1 and {condition}
                    ) AS u
                WHERE
                        u.rn= 1
            ) tcp
                LEFT JOIN t_user_address tua ON tcp.f_userinfoid= tua.f_userinfo_id
    ) dd
GROUP BY
    f_checker_name
ORDER BY
    f_checker_name
