/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.sql.SqlMapper;
import com.aote.util.ExpressionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.SqlHelper;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecursiveSqlServer {
    static Logger log = Logger.getLogger(RecursiveSqlServer.class);
    @Autowired
    private SessionFactory sessionFactory;

    public JSONObject queryTotal(String name, String str) throws Exception {
        JSONObject param = null;
        JSONArray sums = null;
        if (str != null && !str.isEmpty()) {
            JSONObject json = new JSONObject(str);
            if (json.has("data")) {
                param = json.getJSONObject("data");
            }
            if (json.has("sums")) {
                sums = json.getJSONArray("sums");
            }
        }
        Map params = JsonHelper.toMap(param);
        params.put("__n__", "__n__");
        params.put("f_aggregations", this.filterOutOrderBy(sums));
        String sql = this.call(name, params);
        Session session = this.sessionFactory.getCurrentSession();
        JSONArray array = SqlHelper.query((Session)session, (String)sql);
        return array.getJSONObject(0);
    }

    public JSONArray query(String name, String str) throws Exception {
        return this.query(name, 1, 1000, str);
    }

    public JSONArray query(String name, JSONObject params) throws Exception {
        Map map = JsonHelper.toMap((JSONObject)params);
        return this.query(name, 1, 1000, map);
    }

    public JSONArray query(String name, Map<String, Object> params) throws Exception {
        return this.query(name, 1, 1000, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1 || pageSize > 1000) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        }
        Map params = JsonHelper.toMap(param);
        return this.query(name, pageNo, pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        params.put("__n__", "__m__");
        long endRow = pageSize * pageNo;
        long startRow = endRow - (long)(pageSize - 1);
        params.put("__endRow__", endRow + "");
        params.put("__startRow__", startRow + "");
        String sql = this.call(name, params);
        Session session = this.sessionFactory.getCurrentSession();
        JSONArray array = SqlHelper.query((Session)session, (String)sql);
        log.debug((Object)array.toString());
        return array;
    }

    public void run(String sql) {
        Session session = this.sessionFactory.getCurrentSession();
    }

    public String call(String sqlName, JSONObject json) throws Exception {
        Map param = JsonHelper.toMap((JSONObject)json);
        return this.call(sqlName, param);
    }

    public String call(String sqlName, Map<String, Object> params) throws Exception {
        String path = SqlMapper.getSql((String)sqlName);
        String sql = ResourceHelper.getString((String)("/sqls/" + path));
        sql = sql.replace("\r\n", "\n");
        sql = "$" + sql;
        params.put("sql", this);
        sql = ExpressionHelper.run((String)sql, params).toString();
        return sql;
    }

    public JSONArray hqlQuery(String name, JSONObject params) throws Exception {
        Map map = JsonHelper.toMap((JSONObject)params);
        String sql = this.call(name, map);
        Session session = this.sessionFactory.getCurrentSession();
        JSONArray array = SqlHelper.hqlQuery((Session)session, (String)sql);
        return array;
    }

    public JSONArray hqlQuery(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1 || pageSize > 1000) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        }
        Map params = JsonHelper.toMap(param);
        return this.hqlQuery(name, pageNo, pageSize, params);
    }

    public JSONArray hqlQuery(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        String sql = this.call(name, params);
        Session session = this.sessionFactory.getCurrentSession();
        JSONArray array = SqlHelper.hqlQuery((Session)session, (String)sql, (int)(pageNo - 1), (int)pageSize);
        log.debug((Object)array.toString());
        return array;
    }

    private String filterOutOrderBy(JSONArray sums) throws Exception {
        String sql = " ";
        if (sums != null) {
            for (int i = 0; i < sums.length(); ++i) {
                String name = (String)sums.get(i);
                sql = sql + "sum(" + name + ") " + name + ", ";
            }
        }
        sql = sql + " count(*) n, '1' placeholder ";
        return sql;
    }
}

