package com.aote.rs;

import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 */
@Path("location")
@Scope("prototype")
@Component
@Transactional
public class LocationService {
    @Autowired
    private SqlServer sqlServer;

    static Logger log = Logger.getLogger(LocationService.class);

    @Autowired
    private SessionFactory sessionFactory;

    @Path("getLastInfo")
    @POST
    public String getLastInfo(String str){
        log.debug("---开始获取最新位置信息，传入数据=>" + str);
        JSONObject jo = null;
        JSONObject result = new JSONObject();
        try{
            String condition = " 1=1 ";
            jo = new JSONObject(str);
            if(!jo.isNull("date")){
                condition += " and SUBSTRING(f_realtime,0,11)='" + jo.getString("date") + "' ";
            }
//            if(!jo.isNull("code")){ // 部门编码，预留
//                condition += "'11111111111111111 and f_departmentid='" +  jo.getString("code") + "'";
//            }
            JSONArray array = this.sqlServer.query(
                    "select t1.* from t_phone_state t1,(select f_user_id,max(id) mid from t_phone_state where "
                            + condition
                            + " group by  f_user_id) t2 where t1.id=t2.mid"
            );
            JSONObject item = null;
            JSONObject row = null;
            JSONArray data = new JSONArray();
            for(int i=0;i<array.length();i++){
                item = array.getJSONObject(i);
                row = new JSONObject();
                row.put("id",item.getString("f_user_id"));
                row.put("updateTime",item.getString("f_realtime"));
                row.put("status",checkOnLine(item.getString("f_realtime")));
                row.put("name",item.getString("f_user_name"));
                row.put("latitude",item.getString("f_longitude"));
                row.put("longitude",item.getString("f_latitude"));
                data.put(row);
            }
            result.put("data",data);
            result.put("success",true);

            log.debug("查询到的最后一次位置信息数据:" + array.toString());
        }catch(Exception e){
            log.debug("获取最新位置信息异常，异常信息=>" + e.getMessage());
            result.put("success",false);
            result.put("msg",e.getMessage());
        }
        log.debug("获取最新位置信息成功，返回数据:" + result.toString());
        return result.toString();
    }


    @Path("getWhileInfo")
    @POST
    public String getWhileInfo(String str){
        log.debug("---开始获取轨迹信息，传入数据=>" + str);
        JSONObject jo = null;
        JSONObject result = new JSONObject();
        try{
            String condition = " 1=1 ";
            jo = new JSONObject(str);
            if(jo.isNull("beginTime") || jo.isNull("endTime")){
                throw new RuntimeException("获取轨迹信息必须传入开始时间与结束时间!");
            }else{
                condition += " and f_realtime >= '" + jo.getString("beginTime") + "' and f_realtime <= '" + jo.getString("endTime") + "'";
            }
            if(jo.isNull("patrolId")){
                throw new RuntimeException("获取轨迹信息必须传入人员ID!");
            }else{
                condition += " and f_user_id ='" + jo.getString("patrolId") + "' ";
            }
            JSONArray array = this.sqlServer.query(
                    "select * from t_phone_state where " + condition + " order by f_realtime"
            );
            JSONObject item = null;
            JSONObject row = null;
            JSONArray data = new JSONArray();
            for(int i=0;i<array.length();i++){
                item = array.getJSONObject(i);
                row = new JSONObject();
                row.put("accuracy",0);
                row.put("reportTime",item.getString("f_realtime"));
                row.put("name",item.getString("f_user_name"));
                row.put("latitude",item.getString("f_longitude"));
                row.put("longitude",item.getString("f_latitude"));
                if(item.isNull("f_speed")){
                    row.put("speed",0);
                }else{
                    row.put("speed",item.getString("f_speed"));
                }
                data.put(row);
            }
            result.put("data",data);
            result.put("success",true);
            log.debug("获取轨迹信息成功,数据:" + array.toString());
        }catch(Exception e){
            log.debug("获取轨迹信息异常，异常信息=>" + e.getMessage());
            result.put("success",false);
            result.put("msg",e.getMessage());
        }
        log.debug("获取轨迹信息成功，返回数据:" + result.toString());
        return result.toString();
    }

    /**
     * 检查登陆人员目前的状态，当前时间和上传时间小于6分钟是在线，否则为离线
     * 传入时间格式 yyyy-MM-dd HH:mm:ss
     * @param time
     * @return
     */
    public int checkOnLine(String time) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = format.parse(time);
        long millisecond = date.getTime();
        if((System.currentTimeMillis() - millisecond) < 360000){
            return 2;
        }else{
            return 5;
        }
    }
}
