package com.aote.rs;

import java.io.File;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

// 模拟Android端文件上传
public class UploadPlugin {
    public String upload(String urlWithPicId, String fileName) {
        try {
            HttpClient httpClient = new DefaultHttpClient();
            HttpContext httpContext = new BasicHttpContext();
            HttpPost httpPost = new HttpPost(urlWithPicId);
            FileEntity entity = new FileEntity(new File(fileName), "binary/octet-stream");
            httpPost.setEntity(entity);
            HttpResponse response = httpClient.execute(httpPost, httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                return null;
            }
            String result = EntityUtils.toString(response.getEntity(), "UTF8");
            return result;
        } catch (Exception e) {
            return null;
        }
    }
}
