select
ISNULL(tt.f_checker,wjh.f_checker) f_checker,
ISNULL(tt.month,wjh.month) month,
ISNULL(wjh.monthtotal,0) monthwjh,
ISNULL(tt.monthnocheck,0) monthnocheck,
ISNULL(tt.monthhascheck,0) monthhascheck
from (
select
ISNULL(myj.f_checker,mwj.f_checker) f_checker,
ISNULL(myj.month,mwj.month) month,
monthnocheck,
monthhascheck
from  (select count(t.id) monthnocheck,t.month,t.f_checker
  from(
    select
      cpi.*,
      (CONVERT(varchar,cp.f_plan_year) + '-0' + CONVERT(varchar,cp.f_plan_month)) month,
      cp.f_checker,
      cp.f_checker_id
     from t_check_plan_item cpi
    left join
    (select id,f_plan_year,f_plan_month,f_checker,f_checker_id from t_check_plan) cp
    on cp.id = cpi.f_plan_id
  where cp.f_plan_year = DateName(year,GetDate())
    and cp.f_plan_month = DateName(month,GetDate())
    and f_state = '未检'
) t
group by t.month,t.f_checker) mwj
full join
(
select count(t.id) monthhascheck,t.month,t.f_checker
  from(
    select
      cpi.*,
      (CONVERT(varchar,cp.f_plan_year) + '-0' + CONVERT(varchar,cp.f_plan_month)) month,
      cp.f_checker,
      cp.f_checker_id
     from t_check_plan_item cpi
    left join
    (select id,f_plan_year,f_plan_month,f_checker,f_checker_id from t_check_plan) cp
    on cp.id = cpi.f_plan_id
  where cp.f_plan_year = DateName(year,GetDate())
    and cp.f_plan_month = DateName(month,GetDate())
    and f_state = '已检'
) t
group by t.month,t.f_checker
) myj
on mwj.month = myj.month and mwj.f_checker = myj.f_checker
) tt
full join
(
  select
    SUBSTRING(f_offsite_time,0,8) month,
    COUNT(id) monthtotal,
    f_checker_name f_checker from (
      select * from (
        select *,ROW_NUMBER() over(partition by f_checker_name,f_userinfoid order by f_offsite_time desc)as lastcheck
        from (select * from t_check_paper  where f_no_checkplan = '无计划安检' ) tp) t
        where SUBSTRING(f_offsite_time,0,8) = SUBSTRING(CONVERT(varchar,GETDATE(),23),0,8) and lastcheck=1
    )t
       group by f_checker_name,SUBSTRING(f_offsite_time,0,8)
) wjh
on wjh.f_checker = tt.f_checker and wjh.month = tt.month