select
t2.company,
t2.department,
t2.checker,
t2.checkerid,
t2.plan_count,
sum(case when t1.f_entry_status = '入户' then 1 else 0 end) as household_count,
sum(case when t1.f_state = '已检' then 1 else 0 end) as checked_count,
sum(case when t1.f_state = '未检' then 1 else 0 end) as unchecked_count,
sum(case when t1.f_entry_status = '拒检' then 1 else 0 end) as reject_count,
sum(case when t1.f_entry_status = '到访不遇' then 1 else 0 end) as never_met_count,
isnull(round((sum(case when t1.f_state = '已检' then 1 else 0 end)/cast(t2.plan_count as float))*100,1),0) as checked_rate,
isnull(round((sum(case when t1.f_entry_status = '入户' then 1 else 0 end)/cast(t2.plan_count as float))*100,1),0) as household_rate,
isnull(t2.usegas_count,0),
isnull(t2.not_usegas_count,0),
isnull(t2.noplancheck,0) noplancheck_count, --临时安检
isnull(t2.checknum,0) checknum_count --集中安检安检数
from
(
select
t1.company,
t1.department,
t1.noplancheck,
t1.checknum,
t1.checkerid,
t1.checker,
t1.usegas_count,
t1.not_usegas_count,
count(0) as plan_count
from
(
  select o.name as company,
        d.name as department,
        u.name as checker,
        u.id as checkerid,
        cpi.f_last_check_state f_entry_status,
        cpi.f_state f_state,
        s2.checknum noplancheck,
        s3.checknum checknum,
        s4.usegas_count,
        s4.not_usegas_count
        from
		t_organization o
        join t_department d on o.id = d.parentid
        join t_user u on d.id = u.parentid
        join t_check_plan cp on u.id = cp.f_checker_id
        join t_check_plan_item cpi on cp.id = cpi.f_plan_id
        left join (SELECT tp.f_checker_id,COUNT(*) checknum FROM t_check_paper tp WHERE tp.f_no_checkplan = '无计划安检'
        {
          startDate !=$$ :
          $and  tp.f_onsite_time>='{startDate}'$,
          $$
        }
        {
          endDate !=$$ :
          $and  tp.f_offsite_time<='{endDate}'$,
          $$
        }
        GROUP BY tp.f_checker_id) s2 on s2.f_checker_id=cp.f_checker_id
        left join (SELECT tp.f_checker_id,        	
        	sum(case when tp.f_usegas = '已使用' then 1 else 0 end) as usegas_count,
			sum(case when tp.f_usegas = '未使用' then 1 else 0 end) as not_usegas_count
		FROM t_check_paper tp WHERE 1=1
        {
          startDate !=$$ :
          $and  tp.f_onsite_time>='{startDate}'$,
          $$
        }
        {
          endDate !=$$ :
          $and  tp.f_offsite_time<='{endDate}'$,
          $$
        }
        GROUP BY tp.f_checker_id) s4 on s4.f_checker_id=cp.f_checker_id
        left join (SELECT tp.f_checker_id,count(DISTINCT(tp.f_userinfoid)) checknum from t_check_paper tp, t_check_plan tcp where tcp.id= tp.f_check_plan_id and tcp.f_checker is  null
        {
          startDate !=$$ :
          $and  tp.f_onsite_time>='{startDate}'$,
          $$
        }
        {
          endDate !=$$ :
          $and  tp.f_offsite_time<='{endDate}'$,
          $$
        }
        GROUP BY tp.f_checker_id) s3 on s3.f_checker_id=cp.f_checker_id
        where 1=1
    {
      f_subcompany!=$$:
      $ and o.name = '{f_subcompany}'$,
      $$
    }
    {
      department!=$$:
      $
        and d.name = '{department}'
      $,$$
    }
    {
      startDate !=$$ && endDate == $$:
      $and cp.f_plan_year = SUBSTRING('{startDate}',1,4)$,
      $$
    }
    {
      startDate ==$$ && endDate != $$:
      $and cp.f_plan_year = SUBSTRING('{endDate}',1,4)$,
      $$
    }
    {
      startDate !=$$ && endDate != $$:
      $and  (cp.f_plan_year = SUBSTRING('{startDate}',1,4) or cp.f_plan_year = SUBSTRING('{endDate}',1,4))$,
      $$
    }
) t1
group by
t1.company,
t1.department,
t1.checknum,
t1.noplancheck,
t1.usegas_count,
t1.not_usegas_count,
t1.checker,
t1.checkerid
) t2

left join
(
  select
        u.name as checker,
        u.id as checkerid,
        cpi.f_last_check_state f_entry_status,
        cpi.f_state f_state
        from t_organization o
        join t_department d on o.id = d.parentid
        join t_user u on d.id = u.parentid
        join t_check_plan cp on u.id = cp.f_checker_id
        join t_check_plan_item cpi on cp.id = cpi.f_plan_id
        join (
        select * from(
        select *,ROW_NUMBER() over(partition by f_check_item_id order by f_offsite_time)as lastcheck
        from (select * from t_check_paper where f_approved = '已审核') tp) t where lastcheck=1)
        tcp on tcp.f_check_item_id = cpi.id
        left join (SELECT tp.f_checker_id,COUNT(*) checknum FROM t_check_paper tp WHERE tp.f_no_checkplan = '无计划安检'
        {
          startDate !=$$ :
          $and  tp.f_onsite_time>='{startDate}'$,
          $$
        }
        {
          endDate !=$$ :
          $and  tp.f_offsite_time<='{endDate}'$,
          $$
        }
        GROUP BY tp.f_checker_id) s2 on s2.f_checker_id=cp.f_checker_id
        left join (SELECT tp.f_checker_id,count(DISTINCT(tp.f_userinfoid)) checknum from t_check_paper tp, t_check_plan tcp where tcp.id= tp.f_check_plan_id and tcp.f_checker is  null GROUP BY tp.f_checker_id) s3 on s3.f_checker_id=cp.f_checker_id
        where 1=1
{
      f_subcompany!=$$:
      $ and o.name = '{f_subcompany}'$,
      $$
    }
    {
      department!=$$:
      $
        and d.name = '{department}'
      $,$$
    }
    {
      startDate !=$$ && endDate == $$:
      $and cp.f_plan_year = SUBSTRING('{startDate}',1,4)$,
      $$
    }
    {
      startDate ==$$ && endDate != $$:
      $and cp.f_plan_year = SUBSTRING('{endDate}',1,4)$,
      $$
    }
    {
      startDate !=$$ && endDate != $$:
      $and (cp.f_plan_year = SUBSTRING('{startDate}',1,4) or cp.f_plan_year = SUBSTRING('{endDate}',1,4))$,
      $$
    }
    {
      startDate !=$$ :
      $and  tcp.f_onsite_time>='{startDate}'$,
      $$
    }
    {
    endDate !=$$ :
      $and  tcp.f_offsite_time<='{endDate}'$,
      $$
    }
) t1
on t1.checkerid = t2.checkerid
group by
t2.company,
t2.department,
t2.checker,
t2.noplancheck,
t2.checknum,
t2.checkerid,
t2.usegas_count,
t2.not_usegas_count,
t2.plan_count