package com.aote.rs;

import java.util.Map;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.aote.sql.SqlMapper;
import com.aote.util.ExpressionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.SqlHelper;
import java.io.IOException;
import java.io.FileNotFoundException;

@Component
public class RecursiveSqlServer {
	static Logger log = Logger.getLogger(RecursiveSqlServer.class);

	@Autowired
	private SessionFactory sessionFactory;

	/**
	 * 获取SQL语句的合计执行结果
	 * 
	 * @param name
	 *            : sql语句名
	 * @param str
	 *            : sql语句执行参数
	 * @return JSON格式Sql语句执行结果
	 * @throws JSONException
	 */
	public JSONObject queryTotal(String name, String str) throws Exception {
		// 获取参数，求和字段等内容
		JSONObject param = null;
		JSONArray sums = null;
		if (str != null && !str.isEmpty()) {
			JSONObject json = new JSONObject(str);
			if (json.has("data")) {
				param = json.getJSONObject("data");
			}
			if (json.has("sums")) {
				sums = json.getJSONArray("sums");
			}
		}
		Map<String, Object> params = JsonHelper.toMap(param);
		//注入条件，表明是求总行数
		params.put("__n__", "__n__");
		params.put("f_aggregations", filterOutOrderBy(sums));

		// 产生sql语句编译后的结果
		String sql = this.call(name, params);

		Session session = sessionFactory.getCurrentSession();
		JSONArray array = SqlHelper.query(session, sql);
		return array.getJSONObject(0);
	}

	/**
	 * 执行sql分页查询
	 */
	public JSONArray query(String name, String str) throws Exception {
		return query(name, 1, 1000, str);
	}

	// 参数为json对象
	public JSONArray query(String name, JSONObject params) throws Exception {
		Map<String, Object> map = JsonHelper.toMap(params);
		return query(name, 1, 1000, map);
	}

	// 参数为map
	public JSONArray query(String name, Map<String, Object> params)
			throws Exception {
		return query(name, 1, 1000, params);
	}

	public JSONArray query(String name, int pageNo, int pageSize, String str)
			throws Exception {
		// pageNo小于0， 纠正成1
		if (pageNo <= 0) {
			pageNo = 1;
		}

		// pageSize小于0，纠正成1
		if (pageSize < 1 || pageSize > 1000) {
			pageSize = 1000;
		}

		// 拿到json对象参数
		JSONObject param = null;
		if (str != null && !str.isEmpty()) {
			param = new JSONObject(str);
			param = param.getJSONObject("data");
		}
		Map<String, Object> params = JsonHelper.toMap(param);
		return query(name, pageNo, pageSize, params);
	}

	public JSONArray query(String name, int pageNo, int pageSize,
			Map<String, Object> params) throws Exception {
		//注入条件，表明不是求行数
		params.put("__n__", "__m__");
		long endRow = pageSize * pageNo;
		long startRow = endRow - (pageSize - 1);
		params.put("__endRow__", endRow + "");
		params.put("__startRow__", startRow + "");
		// 产生SQL语句编译后的结果
		String sql = this.call(name, params);

		Session session = sessionFactory.getCurrentSession();
		JSONArray array = SqlHelper.query(session, sql);
		// JSONArray array = SqlHelper.query(session, sql, pageNo - 1, pageSize);
		return array;
	}

	// 执行sql语句
	public void run(String sql) {
		Session session = sessionFactory.getCurrentSession();
		SqlHelper.bulkUpdate(session, sql);
	}

	// 基于JSON对象的call函数
	public String call(String sqlName, JSONObject json) throws Exception {
		Map<String, Object> param = JsonHelper.toMap(json);
		return call(sqlName, param);
	}

	// 调用其它sql语句, 产生sql语句经过参数处理的结果串
	public String call(String sqlName, Map<String, Object> params) throws Exception {
		// 获取原始sql语句
		String path = SqlMapper.getSql(sqlName);
		String sql = ResourceHelper.getString("/sqls/" + path);

		// 获取编译后的sql语句
		sql = sql.replace("\r\n", "\n");
		sql = "$" + sql;
		// 把自身注册到执行环境中
		params.put("sql", this);
		sql = ExpressionHelper.run(sql, params).toString();

		return sql;
	}

	// 执行基本hql查询
	public JSONArray hqlQuery(String name, JSONObject params) throws Exception {
		Map<String, Object> map = JsonHelper.toMap(params);
		String sql = this.call(name, map);

		Session session = sessionFactory.getCurrentSession();
		JSONArray array = SqlHelper.hqlQuery(session, sql);
		return array;

	}

	// hql 分页查询入口
	public JSONArray hqlQuery(String name, int pageNo, int pageSize, String str)
			throws Exception {
		// pageNo小于0， 纠正成1
		if (pageNo <= 0) {
			pageNo = 1;
		}

		// pageSize小于0，纠正成1
		if (pageSize < 1 || pageSize > 1000) {
			pageSize = 1000;
		}

		// 拿到json对象参数
		JSONObject param = null;
		if (str != null && !str.isEmpty()) {
			param = new JSONObject(str);
			param = param.getJSONObject("data");
		}
		Map<String, Object> params = JsonHelper.toMap(param);
		return hqlQuery(name, pageNo, pageSize, params);
	}

	// 执行分页查询
	public JSONArray hqlQuery(String name, int pageNo, int pageSize,
			Map<String, Object> params) throws Exception {

		String sql = this.call(name, params);

		Session session = sessionFactory.getCurrentSession();
		JSONArray array = SqlHelper
				.hqlQuery(session, sql, pageNo - 1, pageSize);
		return array;
	}

	// 过滤order by子句，产生求和结果
	private String filterOutOrderBy(JSONArray sums)
			throws Exception {
		String sql = " ";
		// 如果有求和部分，产生求和部分的语句
		if (sums != null) {
			for (int i = 0; i < sums.length(); i++) {
				String name = (String) sums.get(i);
				sql += "sum(" + name + ") " + name + ", ";
			}
		}
		sql += " count(*) n, '1' placeholder ";
		return sql;
	}

}
