SELECT
	ISNULL(m.plan_count, 0) plan_count,
	ISNULL(m.entry_count, 0) entry_count,
	ISNULL(m.novisit_count, 0) novisit_count,
	ISNULL(m.refuse_count, 0) refuse_count,
	ISNULL(m.exception_count, 0) exception_count,
	ISNULL(m.nocheck_count, 0) nocheck_count,
	ISNULL(CAST(((m.entry_count + 0.)/m.plan_count)*100 as decimal(18,2)), 0) entry_rate,
	ISNULL(CAST(((m.entry_count + 0.)/m.plan_count)*100 as decimal(18,2)), 0) check_rate,
	ISNULL(s.supplement_check_count, 0) supplement_check_count,
	ISNULL(y.year_plan_count, 0) year_plan_count,
	ISNULL(y.year_entry_count, 0) year_entry_count,
	ISNULL(y.year_novisit_count, 0) year_novisit_count,
	ISNULL(y.year_refuse_count, 0) year_refuse_count,
	ISNULL(y.year_exception_count, 0) year_exception_count,
	ISNULL(y.year_nocheck_count, 0) year_nocheck_count,
	ISNULL(CAST(((y.year_entry_count + 0.)/y.year_plan_count)*100 as decimal(18,2)), 0) year_entry_rate,
	ISNULL(CAST(((y.year_entry_count + 0.)/y.year_plan_count)*100 as decimal(18,2)), 0) year_check_rate
FROM
	(
		SELECT
			COUNT(cpi.id) plan_count,
			SUM (
				CASE cpr.f_entry_status
					WHEN '入户' THEN 1
					ELSE 0
				END
			) entry_count,
			SUM (
				CASE
					WHEN cpr.f_entry_status = '到访不遇' AND cpr.f_noanser_batch >= 3 THEN 1
					ELSE 0
				END
			) novisit_count,
			SUM (
				CASE cpr.f_entry_status
					WHEN '拒检' THEN 1
					ELSE 0
				END
			) refuse_count,
			SUM (
				CASE
					WHEN cpr.f_address IS NULL AND cpr.f_entry_status IS NOT NULL THEN 1
					ELSE 0
				END
			) exception_count,
			SUM (
				CASE
					WHEN cpr.f_entry_status IS NULL THEN 1
					ELSE 0
				END
			) nocheck_count
		FROM
			t_check_plan cpn
			JOIN t_check_plan_item cpi ON cpi.f_plan_id = cpn.id
			LEFT JOIN (
				SELECT
					id,
					f_check_item_id,
					f_entry_status,
					f_address,
					f_noanser_batch
				FROM
					t_check_paper cpr
				WHERE
					f_upload_date = (
						SELECT
							MAX(f_upload_date)
						FROM
							t_check_paper
						WHERE
							f_check_item_id = cpr.f_check_item_id
						GROUP BY
							f_check_item_id
					)
			) cpr ON cpr.f_check_item_id = cpi.id
		WHERE
		    {condition}
			AND cpn.f_plan_year = '{planYear}'
			AND cpn.f_plan_month = '{planMonth}'
			AND cpn.f_filialeids LIKE '{filialeids}%'
	) m, (
		SELECT
			COUNT(f_upload_date) supplement_check_count
		FROM
			t_check_paper cpr
		WHERE
			f_check_plan_id IN (
				SELECT
					id
				FROM
					t_check_plan
				WHERE
				    {condition}
			        and f_plan_year = '{planYear}'
					AND f_plan_month = '{planMonth}'
					AND f_filialeids LIKE '{filialeids}%'
			)
			AND f_upload_date = (
				SELECT
					MAX(f_upload_date)
				FROM
					t_check_paper
				WHERE
					f_check_item_id = cpr.f_check_item_id
				GROUP BY
					f_check_item_id
			)
			AND cpr.f_upload_date NOT BETWEEN CONVERT(datetime,'{planYear}-{planMonth}-01 00:00:00', 20) AND CONVERT(datetime,'{planYear}-{planMonth + 1}-01 00:00:00', 20)
	) s, (
		SELECT
			COUNT(cpi.id) year_plan_count,
			SUM (
				CASE cpr.f_entry_status
					WHEN '入户' THEN 1
					ELSE 0
				END
			) year_entry_count,
			SUM (
				CASE
					WHEN cpr.f_entry_status = '到访不遇' AND cpr.f_noanser_batch >= 3 THEN 1
					ELSE 0
				END
			) year_novisit_count,
			SUM (
				CASE cpr.f_entry_status
					WHEN '拒检' THEN 1
					ELSE 0
				END
			) year_refuse_count,
			SUM (
				CASE
					WHEN cpr.f_address IS NULL AND cpr.f_entry_status IS NOT NULL THEN 1
					ELSE 0
				END
			) year_exception_count,
			SUM (
				CASE
					WHEN cpr.f_entry_status IS NULL THEN 1
					ELSE 0
				END
			) year_nocheck_count
		FROM
			t_check_plan cpn
			JOIN t_check_plan_item cpi ON cpi.f_plan_id = cpn.id
			LEFT JOIN (
				SELECT
					id,
					f_check_item_id,
					f_entry_status,
					f_address,
					f_noanser_batch
				FROM
					t_check_paper cpr
				WHERE
					f_upload_date = (
						SELECT
							MAX(f_upload_date)
						FROM
							t_check_paper
						WHERE
							f_check_item_id = cpr.f_check_item_id
						GROUP BY
							f_check_item_id
					)
			) cpr ON cpr.f_check_item_id = cpi.id
		WHERE
		    {condition}
			and cpn.f_plan_year = '{planYear}'
			AND cpn.f_filialeids LIKE '{filialeids}%'
	) y
