SELECT
	'安检明细' left_content,
	a.f_residential_area + ' 小区：' +
	'档案总户数 ' + ISNULL(CAST(a.user_count AS VARCHAR), '0') + ' 户，' +
	'计划安检数 ' + ISNULL(CAST(a.plan_count AS VARCHAR), '0') + ' 户，' +
	'入户数 ' + ISNULL(CAST(a.entry_count AS VARCHAR), '0') + ' 户，' +
	'到访不遇户数 ' + ISNULL(CAST(a.novisit_count AS VARCHAR), '0') + ' 户，' +
	'未满3次到访不遇'+ ISNULL(CAST(a.novisit_count1 AS VARCHAR), '0') + ' 户，' +
	'拒检户数 ' + ISNULL(CAST(a.refuse_count AS VARCHAR), '0') + ' 户，' +
	'未安检数 ' + ISNULL(CAST(a.nocheck_count AS VARCHAR), '0') + ' 户，' +
	'隐患户数 ' + ISNULL(CAST(a.defect_count AS VARCHAR), '0') + ' 户'
	main_content
FROM
	(
		SELECT
			cpi.f_residential_area,
			(SELECT COUNT(f_userinfo_id) FROM t_userinfo WHERE f_residential_area = cpi.f_residential_area) user_count,
			COUNT(cpi.id) plan_count,
			SUM (
				CASE cpr.f_entry_status
					WHEN '入户' THEN 1
					ELSE 0
				END
			) entry_count,
			SUM (
				CASE
					WHEN cpr.f_entry_status = '到访不遇' AND cpr.f_noanser_batch >= 3 THEN 1
					ELSE 0
				END
			) novisit_count,
			SUM (
				CASE
					WHEN cpr.f_entry_status = '到访不遇' AND cpr.f_noanser_batch < 3 THEN 1
					ELSE 0
				END
			) novisit_count1,
			SUM (
				CASE cpr.f_entry_status
					WHEN '拒检' THEN 1
					ELSE 0
				END
			) refuse_count,
			SUM (
				CASE
					WHEN cpr.f_address IS NULL AND cpr.f_entry_status IS NOT NULL THEN 1
					ELSE 0
				END
			) exception_count,
			SUM (
				CASE
					WHEN cpr.f_entry_status IS NULL THEN 1
					ELSE 0
				END
			) nocheck_count,
			SUM(
				CASE
					WHEN cpr.f_defect_content LIKE '%有隐患%' THEN 1
					ELSE 0
				END
			) defect_count
		FROM
			t_check_plan cpn
			JOIN t_check_plan_item cpi ON cpi.f_plan_id = cpn.id
			LEFT JOIN (
				SELECT
                    t.*
                FROM
                    (
                        SELECT *, ROW_NUMBER () over ( partition BY f_userinfoid ORDER BY f_upload_date  DESC ) AS lastcheck
                        FROM t_check_paper where
                        {condition}
                        and f_upload_date>=CAST('{planYear}-{planMonth-1}-26 00:00:00' as datetime)
                        and f_upload_date <= CAST('{planYear}-{planMonth}-25 23:59:59' as datetime
                    )
                    ) t
                WHERE
                    t.lastcheck = 1
			) cpr ON cpr.f_userinfoid = cpi.f_userinfoid
		WHERE
		    {condition}
			AND cpn.f_plan_year = '{planYear}'
			AND cpn.f_plan_month = '{planMonth}'
			AND cpn.f_filialeids LIKE '{filialeids}%'
		GROUP BY
			cpi.f_residential_area
	) a
