SELECT
	*
FROM
	(
	SELECT
		ui.f_userinfo_id,
		ui.f_createfile_date,
		uf.f_meternumber,
		f_userinfo_code,
		f_area,
		f_street,
		f_residential_area,
		f_building,
		f_unit,
		f_floor,
		f_room,
		f_address,
		{ month != $$ :
		$1 code,
		$,
		$$
		}
		{
		 nobuy == $是$:
		$
		1 nobuy,
		$,
		$$
		}
		 f_user_name,
		f_user_phone,
		ui.f_user_type,
		f_last_check_state,
		f_last_check_date,
		f_last_check_result,
		f_userproperties,
    f_comments,
		ui.version,
		ui.f_filiale
	FROM
		t_userinfo ui  left join t_userfiles uf on ui.f_userinfo_id = uf.f_userinfo_id
	WHERE
		{ condition }
		AND ui.f_userinfo_id IS NOT NULL AND ui.f_user_state  = '正常'
		{ f_OrgStr != $$ :
		$
		AND ui.f_filialeids LIKE '{f_filialeids}%' $,
		f_OrgStr == $$ :
		$
		AND 1 = 1 $,
		$$
		}
		{
		f_usertype != $$:
		$
		And ui.f_user_type = '{f_usertype}' $,
		$$
		}
		{ f_last_check_state == $未入户$ :
		$
		AND ( f_last_check_state <> '入户' OR f_last_check_state IS NULL ) $,
		f_last_check_state == $$ :
		$
		AND 1 = 1 $,
		f_last_check_state != $未入户$ :
		$
		AND f_last_check_state = '{f_last_check_state}' $,
		$$
		}
		{ month != $$ :
		$
		AND datediff(
			month,
			f_last_check_date,
		getdate()) >={ month }
		$,
		month == $$ :
		$
		AND 1 = 1 $,
		$$
		}
		{
    SafeCheckXZ == $超期安检$ :
    $
    and  ( DATEADD(month,{safeCycle},isnull(f_last_check_date,f_createfile_date)) <= GETDATE())
    $,
    $$
    }
    {
      f_issue_start != $$ && SafeCheckSC == $是$:
      $
      and f_issued_time >= '{f_issue_start}'
      $,
      f_issue_start == $$ && SafeCheckSC == $是$:
      $$,
      $$
    }
    {
      nobuy == $是$:
      $
     and  ( DATEADD(month,6,f_last_sellinggas_date) <= GETDATE())
      $,
      $$
    }
{
	f_issue_start != $$ && f_issue_end != $$  && SafeCheckSC == $否$:
	$
	and  ( f_issued_time < '{f_issue_start}' or f_issued_time > '{f_issue_end} 23:59:59' or f_issued_time is null )
	$,
  f_issue_start == $$ && f_issue_end != $$  && SafeCheckSC == $否$:
	$
	and ( f_issued_time > '{f_issue_end} 23:59:59' or f_issued_time is null )
	$,
	f_issue_start != $$ && f_issue_end == $$  && SafeCheckSC == $否$:
	$
	and  ( f_issued_time < '{f_issue_start}' or f_issued_time is null )
	$,
	$$
}
{
SafeCheckXZ == $应安检$:
 $
 and (isnull(f_last_check_date,convert(varchar(50),f_createfile_date,23)) >= substring(CONVERT(varchar,DATEADD(month,-{safeCycle},'{f_shouldcheck_start}'),23),0,11) and  isnull(f_last_check_date,convert(varchar(50),f_createfile_date,23)) <= substring(CONVERT(varchar,DATEADD(month,-{safeCycle},'{f_shouldcheck_end}'),23),0,11)+' 23:59:59')
 $,
 $$
}
	) a
ORDER BY
	{ orderitem}
