package com.aote.rs;

import com.aote.logic.LogicServer;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;

public class GetNewUserinfo {
    static Logger log = Logger.getLogger(GetNewUserinfo.class);

    @Autowired
    LogicServer logicserver;

    // 请求路径
    private String httpurl;
    public String getHttpurl() {
        return httpurl;
    }

    public void setHttpurl(String httpurl) {
        this.httpurl = httpurl;
    }


    public JSONObject getNewUserinfo(JSONObject param) throws Exception{
        System.out.println(param);
        JSONObject res = new JSONObject();
        JSONObject result = new JSONObject();
        String dataurl = param.getString("url");
        res.put("GasUserID",param.get("f_userinfo_code"));
        result = httpPost(dataurl, res.toString(), false);
        return  result;
    }

    public JSONObject uploadUserinfo(JSONObject param) throws Exception{
        System.out.println(param);
        JSONObject result = new JSONObject();
        result = httpPost("http://192.168.1.121:9020/api/GasUser/UpdateGasUserInfo", param.toString(), false);
        return  result;
    }
    public void uploadDataSync() throws Exception{
        System.out.println("变更用户信息接口开始调用");
        JSONObject param = new JSONObject();
        JSONObject paraminfo = new JSONObject();
        param.put("data",paraminfo);
        Object paperData = logicserver.run("DxnUploadUserinfo",param);
        System.out.println(paperData);
        System.out.println("变更用户信息接口已调用");
    }

    /**
     * post请求
     * @param url         		url地址

     * @param noNeedResponse    不需要返回结�?
     * @return
     */
    public static JSONObject httpPost(String url, String Param, Boolean noNeedResponse){
        //post请求返回结果
        BasicHttpParams httpParams = new BasicHttpParams();
        //通过网络与服务器建立连接的超时时间�?�Httpclient包中通过�?个异步线程去创建与服务器的socket连接，这就是该socket连接的超时时�?
        HttpConnectionParams.setConnectionTimeout(httpParams, 10000);
        //Socket读数据的超时时间，即从服务器获取响应数据�?要等待的时间
        HttpConnectionParams.setSoTimeout(httpParams, 30000);
        DefaultHttpClient httpClient = new DefaultHttpClient(httpParams);
        JSONObject jsonResult = null;
        String jsonStr="{}";
        HttpPost method = new HttpPost(url);
        try {
            if (null != Param) {
                //解决中文乱码问题
                StringEntity entity = new StringEntity(Param, "utf-8");
                entity.setContentEncoding("utf-8");
                entity.setContentType("application/json");//application/x-www-form-urlencoded
                method.setEntity(entity);
            }
            HttpResponse result = httpClient.execute(method);
            /**请求发�?�成功，并得到响�?**/
            if (result.getStatusLine().getStatusCode() == 200) {
                /**读取服务器返回过来的json字符串数�?**/
                jsonStr = EntityUtils.toString(result.getEntity(), "gbk");
                if (noNeedResponse) {
                    return null;
                }
                /**把json字符串转换成json对象**/
            }else{
                jsonStr="{\"url\":\"+url+\",\"error\":{\"errMsg\":\"http请求错误:"+result.getStatusLine().getStatusCode()+"\"},\"RetCode\":\"10\"}";
            }
        } catch (IOException e) {
            //上面设置的超时需要在这里处理
            jsonStr="{\"error\":{\"errMsg\":\"请求超时:"+e.getMessage()+"\"},\"RetCode\":\"11\"}";
        }


        try{
            jsonResult = new JSONObject(jsonStr);
        }
        catch(Exception e){
            log.debug("http返回值格式错误:jsonStr="+jsonStr);
            jsonResult = new JSONObject("{\"error\":{\"errMsg\":\"http返回值格式错误\"},\"RetCode\":\"17\"}");
        }
        //去掉签名字段
        if(jsonResult.has("Signature")){
            jsonResult.remove("Signature");
        }
        //字段名不统一问题
        if(jsonResult.has("Data")){
            Object data=jsonResult.get("Data");
            jsonResult.remove("Data");
            jsonResult.put("data", data);
        }
        log.debug(Param+"请求返回值"+jsonResult);

        return jsonResult;
    }

}
