package com.aote.rs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DaXinNuo{
	static Logger log = Logger.getLogger(DaXinNuo.class);
	public  static String url1;
	public  static String url2;
	public  static String ftpAddr;
	public  static String ftpPort;
	public  static String ftpUser;
	public  static String ftpPassword;
	public  static int h;//时
	public  static int m;//分
	public  static int s;//秒

	public 	static Map<String,String> factorys=new HashMap<String,String>();
	//并发请求返回�?
	public Map<String, JSONObject> resultMap=new HashMap<String, JSONObject>();




	//此方法比较从服务端获取的表厂代码数据与数据库内的数据
	//并生成insert,update,delete,三条SQL,存入JSON对象返回
	//执行这三条语�?,可对数据库内的表厂代码信息进行更�?,没有对应操作则为""
	public JSONObject getUpdateMeterInfo(JSONArray meterDatas,JSONObject newData,String areaCode){


		//返回的JSON
		JSONObject result=new JSONObject();
		//返回的字�?
		String update="";
		String delete="";
		//insert的数�?,insert拼接语句无法在框架中使用
		JSONArray insert=new JSONArray();
		//将meterDatas重新封装成一个MAP,key为meterDatas
		HashMap<String , JSONObject> meterDataMap=new HashMap<String, JSONObject>();
		//处理数据库返回的meterDatas数组,将其放入map,以mfName为key
		for(int i=0;i<meterDatas.length();i++){
			JSONObject meterData=(JSONObject)meterDatas.get(i);
			meterDataMap.put(meterData.getString("mfname"), meterData);
		}
		//遍厉服务器获取的新数据newData,与meterDataMap做比�?
		JSONArray newDataArr=(JSONArray)newData.get("data");
		//添加机表表编号
		newDataArr.put(new JSONObject("{\"MFName\":\""+"机表表厂"+"\",\"MFID\":\""+0+"\"}"));
		//存储要拼接成updateSQL的数�?
		List<String[]> updateSQLList=new ArrayList<String[]>();
		for(int i=0;i<newDataArr.length();i++){
			JSONObject data=(JSONObject)newDataArr.get(i);
			String mfID=data.get("MFID").toString();
			String mfName=data.get("MFName").toString();
			if(meterDataMap.containsKey(mfName)){
				//有已包含的参�?,判断是否相同,不相同拼接为update语句
				JSONObject meterData=meterDataMap.get(mfName);
				String mfID_old=meterData.getString("mfid");
				String mfName_old=meterData.getString("mfname");
				if(!(mfName_old.equals(mfName)&&mfID_old.equals(mfID))){
					updateSQLList.add(new String[]{mfName,mfID});
				}
				meterDataMap.remove(mfName);
			}else{
				//不包�?,拼接为insert语句
				insert.put(new JSONObject("{\"mfName\":\""+mfName+"\",\"mfID\":\""+mfID+"\"}"));
			}
		}
		//循环拼接update语句
		int size=updateSQLList.size();
		if(size>0){
			//返回的字�?,update语句
			String updateSQL1="update  t_gasbrand SET f_mf_id_dxn=case f_meter_brand";
			String updateSQL2=" else f_mf_id_dxn end where f_area_code_dxn="+areaCode;
			for(int i=0;i<size;i++){
				String[] updateData=updateSQLList.get(i);
				updateSQL1+=" when '"+updateData[0]+"' then '"+updateData[1]+"' ";
			}
			update=updateSQL1+updateSQL2;
		}


		//delete语句
		size=meterDataMap.size();
		if(size>0){
			String deleteSQL1="delete from t_gasbrand where f_meter_brand in (";
			String deleteSQL2=") and f_area_code_dxn="+areaCode;
			int count=0;
			for(String key:meterDataMap.keySet()){
				count++;
				deleteSQL1+=" '"+key+"' ";
				if(count<size){
					deleteSQL1+=",";
				}
			}
			delete=deleteSQL1+deleteSQL2;
		}
		result.put("update", update);
		result.put("insert", insert);
		result.put("delete", delete);
		return result;
	}




	/**
     * post请求
     * @param url         		url地址
     * @param jsonParam     	参数
     * @param noNeedResponse    不需要返回结�?
     * @return
     */
    public static JSONObject httpPost(String url,String Param, Boolean noNeedResponse){
        //post请求返回结果
        BasicHttpParams httpParams = new BasicHttpParams();
        //通过网络与服务器建立连接的超时时间�?�Httpclient包中通过�?个异步线程去创建与服务器的socket连接，这就是该socket连接的超时时�?
        HttpConnectionParams.setConnectionTimeout(httpParams, 10000);
        //Socket读数据的超时时间，即从服务器获取响应数据�?要等待的时间
        HttpConnectionParams.setSoTimeout(httpParams, 30000);
        DefaultHttpClient httpClient = new DefaultHttpClient(httpParams);
        JSONObject jsonResult = null;
        String jsonStr="{}";
        HttpPost method = new HttpPost(url);
        try {
            if (null != Param) {
                //解决中文乱码问题
                StringEntity entity = new StringEntity(Param, "utf-8");
                entity.setContentEncoding("utf-8");
                entity.setContentType("application/x-www-form-urlencoded");//application/x-www-form-urlencoded
                method.setEntity(entity);
            }
            HttpResponse result = httpClient.execute(method);
            /**请求发�?�成功，并得到响�?**/
            if (result.getStatusLine().getStatusCode() == 200) {
                /**读取服务器返回过来的json字符串数�?**/
            	jsonStr = EntityUtils.toString(result.getEntity(), "gbk");
                if (noNeedResponse) {
                    return null;
                }
                /**把json字符串转换成json对象**/
            }else{
            	jsonStr="{\"error\":{\"errMsg\":\"http请求错误:"+result.getStatusLine().getStatusCode()+"\",\"retCode\":\"10\"}}";
            }
        } catch (IOException e) {
            //上面设置的超时需要在这里处理
        	jsonStr="{\"error\":{\"errMsg\":\"请求超时:"+e.getMessage()+"\",\"retCode\":\"11\"}}";
        }


        try{
        	jsonResult = new JSONObject(jsonStr);
        }
        catch(Exception e){
        	log.debug("http返回值格式错误:jsonStr="+jsonStr);
        	jsonResult = new JSONObject("{\"error\":{\"errMsg\":\"http返回值格式错误\",\"retCode\":\"17\"}}");
        }
        //去掉签名字段
        if(jsonResult.has("Signature")){
        	jsonResult.remove("Signature");
    	}
        //字段名不统一问题
        if(jsonResult.has("Data")){
        	Object data=jsonResult.get("Data");
        	jsonResult.remove("Data");
        	jsonResult.put("data", data);
        }
        log.debug(Param+"请求返回值"+jsonResult);

        return jsonResult;
    }
}
