package com.aote.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormatterPlugin {
	
	public static String getNow() {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return formatter.format(new Date());
	}

	/**
	 * 比较两个日期的大小
	 * @param dateStr1 第一个日期字符串
	 * @param dateStr2 第二个日期字符串
	 * @return a>=b时为true
	 */
	public static boolean compareDate(String dateStr1, String dateStr2) throws ParseException {
		return compareFormatDate(dateStr1,dateStr2,"yyyy-MM-dd HH:mm:ss");
	}

	/**
	 * 比较两个日期(指定日期格式)的大小
	 * @param dateStr1 第一个日期字符串
	 * @param dateStr2 第二个日期字符串
	 * @param formatStr 指定比较日期的格式
	 * @return dateStr1>=dateStr2时为true
	 */
	public static boolean compareFormatDate(String dateStr1, String dateStr2,String formatStr) throws ParseException {
		SimpleDateFormat format = new SimpleDateFormat(formatStr);
		Date date1 = format.parse(dateStr1);
		Date date2 = format.parse(dateStr2);
		if (date1.before(date2)) {
			return false;
		} else if (date1.after(date2)) {
			return true;
		} else {
			return true;
		}
	}
}
