SELECT
	t1.defect,t2.*
FROM
	(
		SELECT
			ID,
			LISTAGG (f_item_value, ',') WITHIN GROUP (ORDER BY ID) defect
		FROM
			(
				SELECT
					CP.*, c.f_item_value
				FROM
					(
						SELECT
							ID
						FROM
							T_CHECK_PAPER
						WHERE
							f_defect_content LIKE '%有隐患%'
					) cp
				LEFT JOIN (
					SELECT
						f_device_type,
						ID,
						f_paper_id
					FROM
						t_paper_devices
					WHERE
						f_device_type = '燃气表'
				) A ON cp. ID = A .f_paper_id
				LEFT JOIN (
					SELECT
						f_item_name,
						f_device_id,
						ID
					FROM
						t_devices_items
					WHERE
						(
							f_item_name = '表具故障'
							OR f_item_name = '表具隐患类型'
						)
				) b ON A . ID = b.f_device_id
				LEFT JOIN t_devices_items_lists c ON c.f_item_id = b. ID
				WHERE
					c.f_item_value IS NOT NULL
			) T
		GROUP BY
			ID
	) t1
LEFT JOIN (
	SELECT
		CP.*, c.f_item_value
	FROM
		(
			SELECT
				ID,
				f_distinct,
				f_residential_area,
				f_building || '-' || f_unit || '-' || f_floor || '-' || f_room buildingNum,
				f_user_phone,
				f_card_id,
				f_offsite_time,
				f_user_equipmen,
				f_rent
			FROM
				T_CHECK_PAPER
			WHERE
				f_defect_content LIKE '%有隐患%'
		) cp
	LEFT JOIN (
		SELECT
			f_device_type,
			ID,
			f_paper_id
		FROM
			t_paper_devices
		WHERE
			f_device_type = '燃气表'
	) A ON cp. ID = A .f_paper_id
	LEFT JOIN (
		SELECT
			f_item_name,
			f_device_id,
			ID
		FROM
			t_devices_items
		WHERE
			f_item_name = '左右表'
	) b ON A . ID = b.f_device_id
	LEFT JOIN t_devices_items_lists c ON c.f_item_id = b. ID
) t2 ON t1. ID = t2. ID
order by 1