SELECT
	f_distinct,
	-- 所属区域
	f_residential_area1,
	-- 小区名称
	--f_residential_area2,
	SUM,
	-- 户数
	f_street,
	-- 街道
	countBuilding,
	countUnit,
	countPlumb,
	f_residential_properties,
	MAX (f_offsite_time) f_offsite_time,
	-- 小区性质
	f_heating_style,
	COUNT (hasbgl),
	TO_CHAR (
		ROUND (
			COUNT (hasbgl) * 100 / DECODE (SUM, 0, 1, SUM),
			2
		),
		'fm990.00'
	) || '%' bglbl
FROM
	(
		SELECT
			cp.f_distinct,
			-- 所属区域
			ud.f_residential_area f_residential_area1,
			-- 小区名称
			cp.f_residential_area f_residential_area2,
			UD. SUM,
			-- 户数
			udb.countBuilding,
			udu.countUnit,
			UD.f_street,
			-- 街道
			cp.f_residential_properties,
			-- 小区性质
			cp.f_heating_style,
			-- 供暖方式
			cp.f_user_equipmen,
			cp. ID,
			cp.f_userinfoid,
			cp.f_offsite_time,
			countPlumb,
			CASE
		WHEN cp.f_user_equipmen LIKE '%壁挂锅炉%'
		OR cp.f_user_equipmen LIKE '%壁挂炉%' THEN
			'true'
		ELSE
			NULL
		END hasbgl
		FROM
			T_USER_ADDRESS udd
		LEFT JOIN (
			SELECT
				*
			FROM
				(
					SELECT
						ID,
						f_residential_area,
						f_userinfoid,
						F_ENTRY_STATUS,
						f_distinct,
						f_residential_properties,
						f_heating_style,
						f_offsite_time,
						f_user_equipmen,
						ROW_NUMBER () OVER (
							PARTITION BY f_userinfoid
							ORDER BY
								f_offsite_time DESC
						) lastday
					FROM
						T_CHECK_PAPER
				)
			WHERE
				lastday = 1
			AND F_ENTRY_STATUS = '入户'
		) cp ON cp.f_userinfoid = udd.f_userinfo_id
		LEFT JOIN (
			SELECT
				f_residential_area,
				f_street,
				COUNT (f_residential_area) SUM
			FROM
				T_USER_ADDRESS
			WHERE
				F_SPECIAL IS NULL
			GROUP BY
				f_residential_area,
				f_street
		) ud ON udd.f_residential_area = ud.f_residential_area
		AND ud.f_street = udd.f_street
		LEFT JOIN (
			SELECT
				f_residential_area,
				f_street,
				COUNT (f_building) countBuilding
			FROM
				(
					SELECT
						f_residential_area,
						f_building,
						f_street
					FROM
						t_user_address
					WHERE
						F_SPECIAL IS NULL
					GROUP BY
						f_residential_area,
						f_street,
						f_building
					ORDER BY
						f_building DESC
				)
			GROUP BY
				f_residential_area,
				f_street
		) udb ON udb.f_residential_area = ud.f_residential_area
		AND udb.f_street = ud.f_street
		LEFT JOIN (
			SELECT
				f_residential_area,
				f_street,
				COUNT (f_unit) countUnit
			FROM
				(
					SELECT
						f_residential_area,
						f_building,
						f_street,
						f_unit
					FROM
						t_user_address
					WHERE
						F_SPECIAL IS NULL
					GROUP BY
						f_residential_area,
						f_street,
						f_building,
						f_unit
					ORDER BY
						f_building DESC
				)
			GROUP BY
				f_residential_area,
				f_street
		) udu ON udu.f_residential_area = ud.f_residential_area
		AND udu.f_street = ud.f_street
		LEFT JOIN (
			SELECT
				f_residential_area,
				f_street,
				COUNT (f_plumb_id) countPlumb
			FROM
				(
					SELECT
						f_residential_area,
						f_street,
						f_plumb_id
					FROM
						t_user_address ud
					LEFT JOIN T_USERFILES uf ON uf.f_userinfo_id = ud.f_userinfo_id
					WHERE
						F_SPECIAL IS NULL
					GROUP BY
						f_residential_area,
						f_street,
						f_plumb_id
				)
			GROUP BY
				f_residential_area,
				f_street
		) plu ON plu.f_residential_area = ud.f_residential_area
		AND plu.f_street = ud.f_street
	)
WHERE
	{condition} and f_distinct IS NOT NULL
GROUP BY
	f_residential_area1,
	--f_residential_area2,
	f_street,
	SUM,
	countBuilding,
	countUnit,
	f_distinct,
	f_residential_properties,
	f_heating_style,
	countPlumb
ORDER BY
	f_residential_area1