SELECT
	tt.F_CHECKER_NAME,
	tt.F_NO_CHECKPLAN,
	tt.allcount,
	tt.incount,
CASE

		WHEN tt.iscount IS NULL THEN
		0 ELSE tt.ISCOUNT
	END as ISCOUNT,
	tt.totalworkhour,
	tt.totalentrytime,
	tt.averageentrytime,
	tt.householdmax,
	tt.householdmin
FROM
	(
	SELECT
		a.F_CHECKER_NAME,
		a.F_NO_CHECKPLAN,
		count( 0 ) AS allcount,
		max( s.cc ) AS incount,
		max( d.dd ) AS iscount,
		ceil(
			( ( To_date( MAX( F_OFFSITE_TIME ), 'yyyy-mm-dd hh24-mi-ss' ) - To_date( MIN( F_ONSITE_TIME ), 'yyyy-mm-dd hh24-mi-ss' ) ) ) * 24 * 60
		) totalworkhour,
		SUM( ceil( ( ( To_date( F_OFFSITE_TIME, 'yyyy-mm-dd hh24-mi-ss' ) - To_date( F_ONSITE_TIME, 'yyyy-mm-dd hh24-mi-ss' ) ) ) * 24 * 60 ) ) totalentrytime,
		ROUND(
			AVG( ceil( ( ( To_date( F_OFFSITE_TIME, 'yyyy-mm-dd hh24-mi-ss' ) - To_date( F_ONSITE_TIME, 'yyyy-mm-dd hh24-mi-ss' ) ) ) * 24 * 60 ) ),
			2
		) averageentrytime,
		MAX( ceil( ( ( To_date( F_OFFSITE_TIME, 'yyyy-mm-dd hh24-mi-ss' ) - To_date( F_ONSITE_TIME, 'yyyy-mm-dd hh24-mi-ss' ) ) ) * 24 * 60 ) ) householdmax,
		MIN( ceil( ( ( To_date( F_OFFSITE_TIME, 'yyyy-mm-dd hh24-mi-ss' ) - To_date( F_ONSITE_TIME, 'yyyy-mm-dd hh24-mi-ss' ) ) ) * 24 * 60 ) ) householdmin
	FROM
		t_check_paper a
		LEFT JOIN ( SELECT F_NO_CHECKPLAN, F_CHECKER_NAME, count( 0 ) AS cc FROM t_check_paper WHERE F_ENTRY_STATUS = '入户' AND {condition.condition1} GROUP BY F_CHECKER_NAME, F_NO_CHECKPLAN ) s ON a.F_CHECKER_NAME = s.F_CHECKER_NAME
		AND a.F_NO_CHECKPLAN = s.F_NO_CHECKPLAN
		LEFT JOIN ( SELECT F_NO_CHECKPLAN, F_CHECKER_NAME, count( 0 ) AS dd FROM t_check_paper WHERE f_is_safeagreement = '是' AND {condition.condition1} GROUP BY F_CHECKER_NAME, F_NO_CHECKPLAN ) d ON a.F_CHECKER_NAME = d.F_CHECKER_NAME
		AND a.F_NO_CHECKPLAN = d.F_NO_CHECKPLAN
	WHERE
		{condition.condition}
		GROUP BY
		a.F_CHECKER_NAME,
		a.F_NO_CHECKPLAN
	ORDER BY
	a.F_CHECKER_NAME DESC ) tt
	order by 1
