package com.aote.rs;


import com.aote.path.PathServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class PathQuery {
    private static Logger log = Logger.getLogger(PathQuery.class);

    public JSONArray query(String name,Integer pageCount,Integer pageSize,JSONObject params,PathServer path) throws Exception {
        JSONArray array = new JSONArray();
        for (int i =1;i<=pageCount;i++){
            JSONArray res = path.query(name,i,pageSize,params.toString());
            for (int j=0;j<res.length();j++){
                array.put(res.getJSONObject(j));
            }
        }
        return array;
    }
    public JSONArray createAddress(JSONObject address){
        JSONObject addressAdd = null;
        JSONArray result = new JSONArray();
        //楼栋区间
        Integer building_min = address.getInt("f_building_min");
        Integer building_max = address.getInt("f_building_max");
        //单元区间
        Integer unit_min = address.getInt("f_unit_min");
        Integer unit_max = address.getInt("f_unit_max");
        //楼层区间
        Integer floor_min = address.getInt("f_floor_min");
        Integer floor_max = address.getInt("f_floor_max");
        //房间区间
        Integer room_min = address.getInt("f_room_min");
        Integer room_max = address.getInt("f_room_max");

        for (int i = building_min; i <= building_max; i++) {
            for (int j = unit_min; j <= unit_max; j++) {
                for (int m = floor_min; m <= floor_max; m++) {
                    for (int n = room_min; n <= room_max; n++) {
                        addressAdd.put("f_street", address.get("f_street"));
                        addressAdd.put("f_area_id", address.get("f_area_id"));
                        addressAdd.put("f_residential_area", address.get("f_residential_area"));
                        addressAdd.put("f_create_time", address.get("f_create_time"));
                        addressAdd.put("f_building", i);
                        addressAdd.put("f_unit", j);
                        addressAdd.put("f_floor", m);
                        addressAdd.put("f_room", n);
                        result.put(addressAdd);
                    }
                }
            }
        }
        log.debug("生成的地址结果===》"+result);
        return result;
    }
}
