package com.aote.filter;

import com.aote.ThreadResource;
import com.aote.rs.mapper.WebException;
import com.aote.util.GetUserIp;
import org.apache.log4j.Logger;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

public class LdapFilter implements Filter {
    static final Logger log = Logger.getLogger(LdapFilter.class);

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        // 开始时间
        Long startTime = System.currentTimeMillis();
        try {
            // 清除线程变量
            ThreadResource.LoginUser.set(null);
            ThreadResource.ComponentDir.set(null);
            ThreadResource.Token.set(null);
            HttpServletRequest req = (HttpServletRequest) request;

            String ip = GetUserIp.getIpAdrress(req);
            String url = ip + req.getRequestURI();
            log.debug("传入的URL:" + url);

            //登录请求判断
            boolean isOk = LoginFilter.isOk(req, url, log);
            if (!isOk) {
                log.debug("用户认证失败URL:" + url);
                throw new WebException(401, "用户认证失败！");
            }
//      ----------到这鉴权成功-----------
            // 从请求头获取sessionid
            String sessionId = req.getHeader("session");
            ThreadResource.SessionId.set(sessionId == null ? null : Integer.valueOf(sessionId));

            // 从请求头获取公司目录配置
            String componentDir = req.getHeader("componentDir");
            log.debug("获取的componentDir" + componentDir);
            // 如果有公司目录配置，不管人，直接把公司目录放到线程变量里
            if (componentDir != null) {
                ThreadResource.ComponentDir.set(componentDir);
            } else {
                // 获取登陆人
                String loginId = req.getHeader("Token");
                if (loginId != null) {
                    // 把token传递下去
                    ThreadResource.Token.set(loginId);
                    log.debug("loginId=" + loginId);
                }
            }
            log.debug("进入chain.doFilter:" + url);
            chain.doFilter(request, response);
            log.debug("结束chain.doFilter:" + url);
            Long endTime = System.currentTimeMillis();
            log.debug(url + ",拦截器耗时:" + (endTime - startTime));
        } catch (Exception e) {
            log.error("拦截器异常:", e);
            throw e;
        }
    }

    @Override
    public void destroy() {
    }
}
