/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sensitive;

import com.aote.config.SystemConfig;
import com.aote.util.SubstitutionCipherUtil;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class SensitiveDataInterceptor {
    static Logger log = Logger.getLogger(SensitiveDataInterceptor.class);
    private static final String PROTECTED_ROW_LOG = "[PROTECTED]";

    public void beforeSave(String entityName, JSONObject row, HashMap<String, Object> metaData) {
        if (!SystemConfig.DataSecurity.getMaskSensitiveData()) {
            return;
        }
        if (row == null || row.length() == 0 || metaData == null) {
            return;
        }
        HashMap sensitiveConfigs = (HashMap)metaData.get("sensitiveFields");
        if (sensitiveConfigs == null || sensitiveConfigs.isEmpty()) {
            return;
        }
        try {
            this.applySensitiveFieldEncryption(entityName, row, sensitiveConfigs.keySet());
        }
        catch (Exception e) {
            this.handleProcessingError(entityName, row, e);
        }
    }

    private void handleProcessingError(String entityName, JSONObject row, Exception e) {
        String rowInfo = row != null ? PROTECTED_ROW_LOG : "null";
        log.error((Object)("\u654f\u611f\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u5c06\u8df3\u8fc7\u5904\u7406: " + entityName + ", row=" + rowInfo), (Throwable)e);
    }

    private void handleFieldError(String fieldName, Exception e) {
        log.warn((Object)("\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u5f02\u5e38: field=" + fieldName + ", error=" + e.getMessage()));
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u8be6\u7ec6\u9519\u8bef:", (Throwable)e);
        }
    }

    private void applySensitiveFieldEncryption(String entityName, JSONObject row, Set<String> sensitiveFields) {
        log.debug((Object)("\u5904\u7406\u654f\u611f\u5b57\u6bb5(\u5c31\u5730\u52a0\u5bc6): " + entityName + ", \u5b57\u6bb5\u6570=" + sensitiveFields.size()));
        for (String fieldName : sensitiveFields) {
            if (row.opt(fieldName) == null) continue;
            this.processSingleField(fieldName, row);
        }
    }

    private void processSingleField(String fieldName, JSONObject row) {
        Object val = row.opt(fieldName);
        if (!(val instanceof String)) {
            return;
        }
        String strVal = (String)val;
        if (strVal.isEmpty()) {
            return;
        }
        if (this.isMaskedValue(strVal)) {
            row.remove(fieldName);
            log.debug((Object)("\u68c0\u6d4b\u5230\u5df2\u8131\u654f\u8f93\u5165\uff0c\u8df3\u8fc7\u5b57\u6bb5\u66f4\u65b0: " + fieldName));
            return;
        }
        if (SubstitutionCipherUtil.isStrictCipher(strVal)) {
            log.debug((Object)("\u68c0\u6d4b\u5230\u5df2\u662f\u66ff\u4ee3\u5bc6\u7801\u5bc6\u6587\uff0c\u8df3\u8fc7\u52a0\u5bc6: " + fieldName));
            return;
        }
        try {
            String cipher = SubstitutionCipherUtil.encrypt(strVal);
            if (cipher != null) {
                row.put(fieldName, (Object)cipher);
                log.debug((Object)("\u654f\u611f\u5b57\u6bb5\u5df2\u52a0\u5bc6\u5199\u56de: " + fieldName + " (\u539f\u6587\u957f\u5ea6: " + strVal.length() + ", \u5bc6\u6587\u957f\u5ea6: " + cipher.length() + ")"));
            }
        }
        catch (Exception ex) {
            this.handleFieldError(fieldName, ex);
        }
    }

    private boolean isMaskedValue(String value) {
        return value != null && value.contains("*");
    }
}

