/*
 * Decompiled with CFR 0.152.
 */
package com.aote;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParamFilter {
    static final Logger log = Logger.getLogger(ParamFilter.class);
    private static final Map<String, Object> sqlkeywords = new HashMap<String, Object>();
    private static final Pattern[] BLIND_INJECTION_PATTERNS = new Pattern[]{Pattern.compile("(?i)\\b(waitfor\\s+delay|sleep\\s*\\(|benchmark\\s*\\(|pg_sleep\\s*\\()"), Pattern.compile("(?i)\\b(dbms_pipe\\.receive_message|dbms_lock\\.sleep)"), Pattern.compile("(?i)\\b(and|or)\\s+\\d+\\s*[=<>]\\s*\\d+"), Pattern.compile("(?i)\\b(and|or)\\s+['\"]?\\w+['\"]?\\s*[=<>]\\s*['\"]?\\w+['\"]?"), Pattern.compile("(?i)\\b(ascii|char|substring|substr|mid|left|right|len|length)\\s*\\("), Pattern.compile("(?i)\\b(hex|unhex|ord|conv|bin)\\s*\\("), Pattern.compile("(?i)\\b(if\\s*\\(|case\\s+when|iif\\s*\\()"), Pattern.compile("(?i)\\b(cast\\s*\\(|convert\\s*\\(|extractvalue\\s*\\(|updatexml\\s*\\()"), Pattern.compile("(?i)\\b(user\\s*\\(|version\\s*\\(|database\\s*\\(|schema\\s*\\(|@@version|@@user)"), Pattern.compile("(?i)\\b(information_schema|sys\\.|msdb\\.|master\\.)"), Pattern.compile("(?i)\\b0x[0-9a-f]+"), Pattern.compile("(?i)\\bchar\\s*\\(\\s*\\d+"), Pattern.compile("(?i)\\bunion\\s+(all\\s+)?select"), Pattern.compile("(?i)\\bunion\\s*\\(\\s*select"), Pattern.compile("/\\*.*?\\*/"), Pattern.compile("(?i)#.*$"), Pattern.compile("(?i)--.*$"), Pattern.compile("['\"]\\s*[+]\\s*['\"]"), Pattern.compile("\\|\\|"), Pattern.compile("(?i)\\b(load_file|into\\s+outfile|into\\s+dumpfile)"), Pattern.compile("(?i)\\b(exec\\s*\\(|execute\\s*\\(|sp_executesql)")};
    private static final Map<String, RequestTracker> requestTrackers = new ConcurrentHashMap<String, RequestTracker>();
    private static final int MAX_REQUESTS_PER_MINUTE = 60;
    private static final long REQUEST_WINDOW_MS = 60000L;

    public static void checkSqlMapEnhanced(Map<String, Object> map, String clientIp) {
        if (!ParamFilter.checkRateLimit(clientIp)) {
            throw new RuntimeException("\u8bf7\u6c42\u9891\u7387\u8fc7\u9ad8\uff0c\u5df2\u88ab\u6682\u65f6\u963b\u6b62");
        }
        for (Object m : map.values()) {
            ParamFilter.checkSqlStrEnhanced(String.valueOf(m), clientIp);
        }
    }

    public static void checkSqlMap(Map<String, Object> map) {
        for (Object m : map.values()) {
            ParamFilter.checkSqlStrEnhanced(String.valueOf(m), "unknown");
        }
    }

    public static void checkSqlJsonStrEnhanced(String jsonStr, String clientIp) {
        log.debug((Object)("\u5f85\u68c0\u6570\u636e\uff1a" + jsonStr));
        if (!ParamFilter.checkRateLimit(clientIp)) {
            throw new RuntimeException("\u8bf7\u6c42\u9891\u7387\u8fc7\u9ad8\uff0c\u5df2\u88ab\u6682\u65f6\u963b\u6b62");
        }
        JSONObject jsonObject = new JSONObject(jsonStr);
        ParamFilter.checkSqlJsonEnhanced(jsonObject, clientIp);
    }

    public static void checkSqlJsonStr(String jsonStr) {
        log.debug((Object)("\u5f85\u68c0\u6570\u636e\uff1a" + jsonStr));
        JSONObject jsonObject = new JSONObject(jsonStr);
        ParamFilter.checkSqlJsonEnhanced(jsonObject, "unknown");
    }

    public static void checkSqlJsonEnhanced(JSONObject jsonObject, String clientIp) {
        for (String k : jsonObject.keySet()) {
            Object v = jsonObject.get(k);
            ParamFilter.checkSqlJsonVEnhanced(v, clientIp);
        }
    }

    public static void checkSqlJson(JSONObject jsonObject) {
        ParamFilter.checkSqlJsonEnhanced(jsonObject, "unknown");
    }

    public static void checkSqlJsonVEnhanced(Object v, String clientIp) {
        if (v instanceof JSONArray) {
            JSONArray ja = new JSONArray(String.valueOf(v));
            for (int i = 0; i < ja.length(); ++i) {
                Object value = ja.get(i);
                ParamFilter.checkSqlJsonVEnhanced(value, clientIp);
            }
        } else if (v instanceof JSONObject) {
            ParamFilter.checkSqlJsonEnhanced((JSONObject)v, clientIp);
        } else if (v instanceof String) {
            String vStr = String.valueOf(v);
            if (vStr.startsWith("{")) {
                ParamFilter.checkSqlJsonVEnhanced(new JSONObject(vStr), clientIp);
            } else if (vStr.startsWith("[")) {
                ParamFilter.checkSqlJsonVEnhanced(new JSONArray(vStr), clientIp);
            } else {
                ParamFilter.checkSqlStrEnhanced(vStr, clientIp);
            }
        }
    }

    public static void checkSqlJsonV(Object v) {
        ParamFilter.checkSqlJsonVEnhanced(v, "unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkSqlStrEnhanced(String str, String clientIp) {
        if (StringUtils.isBlank((String)str)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            ParamFilter.checkBlindInjectionPatterns(str, clientIp);
            ParamFilter.checkSqlKeywords(str, clientIp);
            ParamFilter.checkEncodingBypass(str, clientIp);
            ParamFilter.checkSqlSyntax(str, clientIp);
        }
        finally {
            long endTime = System.currentTimeMillis();
            long processingTime = endTime - startTime;
            if (processingTime > 100L) {
                log.warn((Object)("\u68c0\u6d4b\u5904\u7406\u65f6\u95f4\u5f02\u5e38: " + processingTime + "ms, IP: " + clientIp + ", \u8f93\u5165: " + str));
            }
        }
    }

    public static void checkSqlStr(String str) {
        ParamFilter.checkSqlStrEnhanced(str, "unknown");
    }

    private static void checkBlindInjectionPatterns(String str, String clientIp) {
        String lowerStr = str.toLowerCase();
        for (Pattern pattern : BLIND_INJECTION_PATTERNS) {
            if (!pattern.matcher(str).find() && !pattern.matcher(lowerStr).find()) continue;
            log.error((Object)("\u68c0\u6d4b\u5230\u76f2\u6ce8\u653b\u51fb\u6a21\u5f0f, IP: " + clientIp + ", \u6a21\u5f0f: " + pattern.pattern() + ", \u8f93\u5165: " + str));
            throw new RuntimeException("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
    }

    private static void checkSqlKeywords(String str, String clientIp) {
        String[] strs;
        String lowerStr = str.toLowerCase().trim();
        String normalizedStr = lowerStr.replaceAll("\\s+", " ").replaceAll("/\\*.*?\\*/", "").replaceAll("--.*$", "").replaceAll("#.*$", "");
        for (String trimStr : strs = normalizedStr.split("[\\s,;()]+")) {
            if (!StringUtils.isNotBlank((String)trimStr) || !sqlkeywords.containsKey(trimStr)) continue;
            log.error((Object)("\u53c2\u6570\u5305\u542bSQL\u5173\u952e\u5b57: " + trimStr + ", IP: " + clientIp + ", \u5b8c\u6574\u8f93\u5165: " + str));
            throw new RuntimeException("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
    }

    private static void checkEncodingBypass(String str, String clientIp) {
        if (str.matches(".*\\b0x[0-9a-fA-F]+.*")) {
            log.error((Object)("\u68c0\u6d4b\u5230\u5341\u516d\u8fdb\u5236\u7f16\u7801\u5c1d\u8bd5, IP: " + clientIp + ", \u8f93\u5165: " + str));
            throw new RuntimeException("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
        if (str.matches(".*\\\\u[0-9a-fA-F]{4}.*")) {
            log.error((Object)("\u68c0\u6d4b\u5230Unicode\u7f16\u7801\u5c1d\u8bd5, IP: " + clientIp + ", \u8f93\u5165: " + str));
            throw new RuntimeException("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
        String decoded = str.replaceAll("%20", " ").replaceAll("%27", "'").replaceAll("%22", "\"").replaceAll("%3B", ";").replaceAll("%2D%2D", "--").replaceAll("%2F%2A", "/*");
        if (!decoded.equals(str)) {
            ParamFilter.checkSqlKeywords(decoded, clientIp);
        }
    }

    private static void checkSqlSyntax(String str, String clientIp) {
        String lowerStr = str.toLowerCase();
        if (lowerStr.contains(";") && (lowerStr.contains("select") || lowerStr.contains("insert") || lowerStr.contains("update") || lowerStr.contains("delete"))) {
            log.error((Object)("\u68c0\u6d4b\u5230\u591a\u8bed\u53e5\u6ce8\u5165\u5c1d\u8bd5, IP: " + clientIp + ", \u8f93\u5165: " + str));
            throw new RuntimeException("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
        if ((lowerStr.contains("--") || lowerStr.contains("/*")) && (lowerStr.contains("select") || lowerStr.contains("union"))) {
            log.error((Object)("\u68c0\u6d4b\u5230\u6ce8\u91ca\u7b26SQL\u6ce8\u5165\u5c1d\u8bd5, IP: " + clientIp + ", \u8f93\u5165: " + str));
            throw new RuntimeException("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
        if (lowerStr.matches(".*\\b(select|insert|update|delete).*\\b(select|insert|update|delete).*")) {
            log.error((Object)("\u68c0\u6d4b\u5230\u5806\u53e0\u67e5\u8be2\u5c1d\u8bd5, IP: " + clientIp + ", \u8f93\u5165: " + str));
            throw new RuntimeException("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
    }

    private static boolean checkRateLimit(String clientIp) {
        if (StringUtils.isBlank((String)clientIp) || "unknown".equals(clientIp)) {
            return true;
        }
        RequestTracker tracker = requestTrackers.computeIfAbsent(clientIp, k -> new RequestTracker());
        boolean allowed = tracker.checkAndUpdate();
        if (requestTrackers.size() > 10000) {
            ParamFilter.cleanupExpiredTrackers();
        }
        return allowed;
    }

    private static void cleanupExpiredTrackers() {
        long now = System.currentTimeMillis();
        requestTrackers.entrySet().removeIf(entry -> {
            RequestTracker tracker = (RequestTracker)entry.getValue();
            return now - tracker.lastRequestTime > 360000L;
        });
    }

    static {
        sqlkeywords.put("select", "select");
        sqlkeywords.put("insert", "insert");
        sqlkeywords.put("update", "update");
        sqlkeywords.put("delete", "delete");
        sqlkeywords.put("from", "from");
        sqlkeywords.put("drop", "drop");
        sqlkeywords.put("count", "count");
        sqlkeywords.put("table", "table");
        sqlkeywords.put("truncate", "truncate");
        sqlkeywords.put("declare", "declare");
        sqlkeywords.put("asc(", "asc(");
        sqlkeywords.put("mid(", "mid(");
        sqlkeywords.put("char(", "char(");
        sqlkeywords.put("where", "where");
        sqlkeywords.put("master", "master");
        sqlkeywords.put("netlocalgroup", "netlocalgroup");
        sqlkeywords.put("administrators", "administrators");
        sqlkeywords.put("xp_cmdshell", "xp_cmdshell");
        sqlkeywords.put("exec", "exec");
        sqlkeywords.put("execute", "execute");
        sqlkeywords.put("xp_", "xp_");
        sqlkeywords.put("sp_", "sp_");
        sqlkeywords.put("0x", "0x");
        sqlkeywords.put(";", ";");
        sqlkeywords.put("or", "or");
        sqlkeywords.put("\"t_user\"", "\"t_user\"");
        sqlkeywords.put("--", "--");
        sqlkeywords.put("#", "#");
        sqlkeywords.put("union", "union");
        sqlkeywords.put("/", "/");
        sqlkeywords.put("//", "//");
        sqlkeywords.put("waitfor", "waitfor");
        sqlkeywords.put("delay", "delay");
        sqlkeywords.put("sleep", "sleep");
        sqlkeywords.put("benchmark", "benchmark");
        sqlkeywords.put("ascii", "ascii");
        sqlkeywords.put("substring", "substring");
        sqlkeywords.put("substr", "substr");
        sqlkeywords.put("length", "length");
        sqlkeywords.put("if(", "if(");
        sqlkeywords.put("case", "case");
        sqlkeywords.put("when", "when");
        sqlkeywords.put("extractvalue", "extractvalue");
        sqlkeywords.put("updatexml", "updatexml");
        sqlkeywords.put("cast(", "cast(");
        sqlkeywords.put("convert(", "convert(");
        sqlkeywords.put("user()", "user()");
        sqlkeywords.put("version()", "version()");
        sqlkeywords.put("database()", "database()");
        sqlkeywords.put("@@version", "@@version");
        sqlkeywords.put("@@user", "@@user");
        sqlkeywords.put("information_schema", "information_schema");
        sqlkeywords.put("load_file", "load_file");
        sqlkeywords.put("into", "into");
        sqlkeywords.put("outfile", "outfile");
        sqlkeywords.put("dumpfile", "dumpfile");
    }

    static class RequestTracker {
        private long lastRequestTime = System.currentTimeMillis();
        private int requestCount = 1;
        private boolean blocked = false;
        private long blockUntil;

        RequestTracker() {
        }

        boolean checkAndUpdate() {
            long now = System.currentTimeMillis();
            if (this.blocked && now < this.blockUntil) {
                return false;
            }
            if (this.blocked && now >= this.blockUntil) {
                this.blocked = false;
                this.requestCount = 0;
            }
            if (now - this.lastRequestTime > 60000L) {
                this.requestCount = 1;
                this.lastRequestTime = now;
                return true;
            }
            ++this.requestCount;
            this.lastRequestTime = now;
            if (this.requestCount > 60) {
                this.blocked = true;
                this.blockUntil = now + 300000L;
                log.warn((Object)("IP\u8bf7\u6c42\u9891\u7387\u8fc7\u9ad8\u88ab\u963b\u6b62. \u8bf7\u6c42\u6b21\u6570: " + this.requestCount));
                return false;
            }
            return true;
        }
    }
}

