package com.aote.util;

import com.aote.filter.LoginFilter;
import com.aote.redis.RedisUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import org.redisson.client.codec.StringCodec;
import com.auth0.jwt.interfaces.DecodedJWT;
import org.apache.log4j.Logger;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 操作Jwt的工具类
 */
public class JwtUtilNew {
    /**
     * token密钥
     */
    private static final String TOKEN_SECRET = "05b5d4c183c559d9a440f416cd08d3b1";

    static Logger log = Logger.getLogger(LoginFilter.class);

    private final static RedisUtil redisUtil = RedisUtil.getInstance();

    public static String getToken(String id, String eName, String pwd) {
        try {
            //token加密算法
            Algorithm algorithm = null;
            try {
                algorithm = Algorithm.HMAC256(TOKEN_SECRET);
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            Map<String, Object> hand = new HashMap<>(2);
            hand.put("type", "JWT");
            hand.put("alg", "HMAC256");

            String token = JWT.create()
                    .withHeader(hand)
                    .withClaim("Id", id)
                    .withClaim("eName", eName)
                    .withClaim("password", pwd)
                    .sign(algorithm);
            redisUtil.set("User_" + eName, token);
            return token;
        } catch (Exception e) {
            log.debug("生产jwt异常：", e);
            throw new RuntimeException("生产jwt异常", e);
        }
    }

    public static boolean tokenVerify(String token) {
        try {
            JWTVerifier jwtVerifier = JWT.require(Algorithm.HMAC256(TOKEN_SECRET)).build();
            DecodedJWT ver = jwtVerifier.verify(token);
//            String id = ver.getClaim("Id").asString();
            String eName = ver.getClaim("eName").asString();

            String saveToken = redisUtil.get("User_" + eName, new StringCodec());
            return Objects.equals(saveToken, token);
        } catch (Exception e) {
            log.debug("验证JWT异常:", e);
            return false;
        }
    }

    public static String getLoginId(String token) {
        JWTVerifier jwtVerifier = null;
        try {
            jwtVerifier = JWT.require(Algorithm.HMAC256(TOKEN_SECRET)).build();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        DecodedJWT ver = jwtVerifier.verify(token);
        return ver.getClaim("Id").asString();
    }

}
