/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;

public class IOTools {
    public static void getStream(String path, StreamRunnable runnable) {
        IOTools.getStream(path, runnable, notFindPath -> {});
    }

    public static void getStream(String path, StreamRunnable runnable, NotFindable notFindable) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        try (InputStream stream = IOTools.class.getResourceAsStream((String)path);){
            if (stream != null) {
                runnable.run(stream);
            } else {
                notFindable.run((String)path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasResource(String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return IOTools.class.getResource((String)path) != null;
    }

    public static String readText(String path) {
        AtomicReference builder = new AtomicReference();
        IOTools.getStream(path, stream -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line).append("\r\n");
                }
                builder.set(sb.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, fileName -> {
            throw new RuntimeException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        });
        return (String)builder.get();
    }

    @FunctionalInterface
    public static interface NotFindable {
        public void run(String var1);
    }

    @FunctionalInterface
    public static interface StreamRunnable {
        public void run(InputStream var1);
    }
}

