/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.aote.ThreadResource;
import com.aote.entity.EntityServer;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.stereotype.Component;

@Component
public class SqlMapper {
    static Logger LOGGER = Logger.getLogger(SqlMapper.class);
    private static Map<String, Map<String, String>> map;

    public static String getSql(String alias) {
        String result;
        Object newAlias = switch (EntityServer.findDialect()) {
            case "Oracle" -> alias + "_oracle";
            case "MySQL" -> alias + "_mysql";
            default -> alias;
        };
        if (!map.containsKey(newAlias)) {
            if (map.containsKey(alias)) {
                newAlias = alias;
            } else {
                return null;
            }
        }
        if ((result = SqlMapper.getSqlByUser((String)newAlias)) != null) {
            return result;
        }
        return map.get(newAlias).get("path");
    }

    public static String getAttr(String alias, String name) {
        if (map.containsKey(alias)) {
            return map.get(alias).get(name);
        }
        return null;
    }

    public static Map<String, Map<String, String>> getMap() {
        return map;
    }

    public static String getSqlByUser(String alias) {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = "/" + dir + "/sqls/" + alias + ".sql";
        if (map.containsKey(dir + "_" + alias)) {
            return map.get(dir + "_" + alias).get("path");
        }
        SAXReader reader = new SAXReader();
        try {
            SqlMapper.putMap(dir, reader, "filiale", true);
            if (map.containsKey(dir + "_" + alias)) {
                return map.get(dir + "_" + alias).get("path");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Sql\u8fd0\u884c\u8bf7\u6c42\u5934\u5305\u542b\u5206\u516c\u53f8\uff1a" + dir + ",\u83b7\u53d6\u5206\u516c\u53f8\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38:" + path + ",\u5ffd\u7565\u8bf7\u6c42\u5934\u914d\u7f6e"));
        }
        if (SqlMapper.class.getResource(path) != null) {
            return path;
        }
        return null;
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        InputStream module = SqlMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            InputStream input;
            if (module != null) {
                SqlMapper.parseModule(module);
            }
            if ((input = SqlMapper.class.getClassLoader().getResourceAsStream("sql.xml")) != null) {
                SqlMapper.loadOneMap(input, reader, null, null, false);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void loadOneMap(InputStream input, SAXReader reader, String name, String parent, boolean isFiliale) throws Exception {
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("sql");
        while (it.hasNext()) {
            Element element = (Element)it.next();
            Object aliasLogic = element.attribute("alias").getValue();
            if (isFiliale) {
                aliasLogic = name + "_" + (String)aliasLogic;
            }
            String pathLogic = element.attribute("path").getValue();
            String mobile = element.attributeValue("mobile");
            String language = element.attributeValue("language");
            if (name != null && map.containsKey(aliasLogic)) {
                throw new Exception("\u522b\u540d" + (String)aliasLogic + "\u5df2\u5b58\u5728");
            }
            String path = SqlMapper.getPath(name, parent, pathLogic);
            HashMap<String, Object> logic = new HashMap<String, Object>();
            logic.put("alias", aliasLogic);
            logic.put("path", path);
            logic.put("mobile", mobile);
            logic.put("language", language);
            map.put((String)aliasLogic, logic);
        }
    }

    private static String getPath(String name, String parent, String path) {
        if (name == null) {
            return "sqls/" + path;
        }
        if (parent == null) {
            return name + "/sqls/" + path;
        }
        return parent + "/" + name + "/sqls/" + path;
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            SqlMapper.putMap(name, reader, null, false);
            Iterator children = elm.elementIterator("module");
            while (children.hasNext()) {
                Element childElm = (Element)children.next();
                String childname = childElm.attribute("name").getValue();
                SqlMapper.putMap(childname, reader, name, false);
            }
        }
    }

    private static void putMap(String name, SAXReader reader, String parent, boolean isFiliale) throws Exception {
        String str = parent == null ? name + "/sql.xml" : parent + "/" + name + "/sql.xml";
        InputStream moduleSql = SqlMapper.class.getClassLoader().getResourceAsStream(str);
        if (moduleSql == null) {
            throw new RuntimeException("\u6ce8\u610f\uff01\uff01\uff01\u627e\u4e0d\u5230\u6587\u4ef6\uff1a" + str);
        }
        SqlMapper.loadOneMap(moduleSql, reader, name, parent, isFiliale);
    }

    static {
        SqlMapper.loadMap();
    }
}

