/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.logic.LogicServer;
import com.aote.transaction.SessionPool;
import com.aote.util.ResourceHelper;
import com.aote.util.Util;
import com.aote.util.other.AESUtil;
import com.aote.util.other.RSAUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javassist.NotFoundException;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.sf.json.JSON;
import net.sf.json.xml.XMLSerializer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Path(value="logic")
@Singleton
@Component
public class LogicService {
    static final Logger log = Logger.getLogger(LogicService.class);
    static final Logger reviewLog = Logger.getLogger((String)"reviewLog");
    @Autowired
    private SessionPool sessionPool;
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private ResourceHelper resourceHelper;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    public static final ThreadLocal<String> reviewKey = new ThreadLocal();
    public static final Map<String, JSONArray> reviewCache = new HashMap<String, JSONArray>();

    @GET
    @Path(value="/clear")
    public String clearLogicCache() {
        ResourceHelper.clearLogicCache();
        return "ok";
    }

    @GET
    @Path(value="/clearall")
    public String clearAllCache() {
        ResourceHelper.clearLogicCache();
        ResourceHelper.clearSqlCache();
        ResourceHelper.clearPathCache();
        return "ok";
    }

    @GET
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        String values = params.toString();
        return (Response)this.runMain(logicName, values);
    }

    @POST
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        if (values.startsWith("$")) {
            values = RSAUtil.descrypt(values.substring(1));
        }
        values = Util.aesWhiteList(request, values);
        values = this.getValues(values, request);
        return (Response)this.runMain(logicName, values);
    }

    @GET
    @Path(value="async/{logic}")
    public Response asyncXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        try {
            this.runAsync(logicName, params.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (params.has("msg")) {
            return Response.ok((Object)params.getJSONArray("msg").get(0)).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="async/{logic}")
    public Response asyncXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) {
        try {
            this.runAsync(logicName, values);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Response.ok().build();
    }

    private String getValues(String values, HttpServletRequest request) {
        if (!values.startsWith("{")) {
            JSONObject paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = headerNames.nextElement().toString();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                if (header.has("request_id")) {
                    reviewKey.set(String.valueOf(header.get("request_id")));
                }
                paramJson.put("header", (Object)header);
            }
            values = paramJson.toString();
        }
        return values;
    }

    public String xtSave(String logicName, String values) throws Exception {
        return this.xtSave(logicName, values, null).getEntity().toString();
    }

    private Object runMain(String logicName, String values) throws Exception {
        JSONObject jsonObject = new JSONObject(values);
        if (jsonObject.has("action")) {
            int id = this.judgeAction(jsonObject);
            return "" + id;
        }
        String id = reviewKey.get();
        long begin = System.currentTimeMillis();
        JSONObject reviewObj = new JSONObject();
        if (id != null) {
            reviewCache.put(id, new JSONArray());
        }
        try {
            JSONObject paramJson;
            String result = AESUtil.encryptData(jsonObject, "rs/logic/" + logicName, data -> this.logicServer.runMain(logicName, data));
            Response.ResponseBuilder builder = Response.ok();
            if (result.startsWith("{") && (paramJson = new JSONObject(result)).has("header") && paramJson.has("content")) {
                Map paramHeader = paramJson.getJSONObject("header").toMap();
                for (Map.Entry stringObjectEntry : paramHeader.entrySet()) {
                    builder.header((String)stringObjectEntry.getKey(), (Object)String.valueOf(stringObjectEntry.getValue()));
                }
                Response response = builder.type("text/plain").entity((Object)String.valueOf(paramJson.get("content"))).build();
                return response;
            }
            reviewObj.put("status", 0);
            Response response = builder.entity((Object)result).build();
            return response;
        }
        catch (Exception e) {
            reviewObj.put("status", -1);
            throw e;
        }
        finally {
            if (id != null) {
                long end = System.currentTimeMillis();
                reviewObj.put("requestId", (Object)id);
                reviewObj.put("bTime", begin);
                reviewObj.put("eTime", end);
                reviewObj.put("constTime", end - begin);
                reviewObj.put("type", (Object)"logic");
                reviewObj.put("items", (Object)reviewCache.get(id));
                reviewLog.debug((Object)reviewObj);
                reviewKey.remove();
                reviewCache.remove(id);
            }
        }
    }

    @POST
    @Path(value="xml/{logic}")
    @Consumes(value={"application/xml"})
    public String xmlXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        JSON json;
        int lens;
        ServletInputStream inputStream = request.getInputStream();
        StringBuilder content = new StringBuilder();
        byte[] b = new byte[1024];
        while ((lens = inputStream.read(b)) > 0) {
            content.append(new String(b, 0, lens));
        }
        String strcont = content.toString();
        try {
            XMLSerializer xmlSerializer = new XMLSerializer();
            json = xmlSerializer.read(strcont);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4f20\u5165\u7684\u6570\u636e\u4e0d\u662fXML\u683c\u5f0f");
        }
        String jsonString = new JSONObject().put("data", (Object)json).toString();
        log.debug((Object)("\u8c03\u7528XML\u63a5\u53e3\uff0cLogic\uff1a" + logicName + "  \u53c2\u6570\uff1a" + String.valueOf(json)));
        return this.logicServer.runMain(logicName, jsonString);
    }

    @PostConstruct
    public void redisCacheLogic() {
        this.logicServer.redisCacheLogic();
    }

    private int judgeAction(JSONObject jsonObject) throws NotFoundException {
        String actObj = (String)jsonObject.get("action");
        if ("begin".equals(actObj)) {
            int sessionid = this.sessionPool.createSession();
            return sessionid;
        }
        int sessionid = jsonObject.getInt("id");
        return sessionid;
    }

    private void runAsync(String logicName, String values) throws Exception {
        CompletableFuture.supplyAsync(() -> {
            try {
                return this.runMain(logicName, values);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (Executor)this.taskExecutor).exceptionally(throwable -> {
            log.error((Object)"\u5f02\u6b65\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38.", throwable);
            return null;
        });
    }
}

