/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.config.SystemConfig;
import com.aote.entity.EntityServer;
import com.aote.exception.ExceptionLogManage;
import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicMapper;
import com.aote.logic.PluginMapper;
import com.aote.path.PathMapper;
import com.aote.path.PathServer;
import com.aote.redis.RedisUtil;
import com.aote.rs.LogicService;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlMapper;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.ExceptionHelper;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class LogicServer {
    static final Logger log = Logger.getLogger(LogicServer.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private PathServer pathServer;
    @Autowired
    public SessionPool sessionPool;
    @Autowired
    public SessionFactory sessionFactory;
    @Autowired
    private ExceptionLogManage exceptionLogManage;
    private final RedisUtil redisUtil = RedisUtil.getInstance();
    private JSONObject context = null;

    public Object run(String name, String str) throws Exception {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                param = new JSONObject(str);
                if (!param.isNull("context")) {
                    this.context = param.getJSONObject("context");
                }
                if (!param.isNull("data") && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.run(name, param, this.context);
    }

    public Object run(String name, JSONObject param) throws Exception {
        return this.run(name, param, this.context);
    }

    public Object run(String name, JSONObject param, JSONObject context) throws Exception {
        JSONArray reviewArray;
        String message = "\u7ef4\u62a4\u4fe1\u606f:\u5f00\u59cb\u6267\u884cLogic[" + name + "]\uff0c\u53c2\u6570\uff1a" + String.valueOf(param);
        log.debug((Object)message);
        String path = LogicMapper.getLogic(name);
        log.debug((Object)(name + "\u4e1a\u52a1\u903b\u8f91\u8def\u5f84:" + path));
        if (path == null) {
            throw new RuntimeException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name);
        }
        long begin = System.currentTimeMillis();
        String reviewKey = LogicService.reviewKey.get();
        JSONObject reviewItem = new JSONObject();
        if (reviewKey != null && (reviewArray = LogicService.reviewCache.get(reviewKey)) != null) {
            reviewItem.put("bTime", begin);
            reviewItem.put("name", (Object)name);
            reviewItem.put("type", (Object)"logic");
            reviewArray.put((Object)reviewItem);
        }
        try {
            Object object;
            block18: {
                InputStream source = ResourceHelper.getStream(path);
                try {
                    Map<String, Object> maps = this.getContext(param, context);
                    String language = LogicMapper.getAttr(name, "language");
                    Object result = ExpressionHelper.run(source, maps, language, s -> s);
                    reviewItem.put("status", 0);
                    object = result;
                    if (source == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
                    }
                    catch (Exception e) {
                        reviewItem.put("status", -1);
                        throw e;
                    }
                }
                source.close();
            }
            return object;
        }
        finally {
            long end = System.currentTimeMillis();
            long time = end - begin;
            String engMessage = "\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cLogic[" + name + "]\u8017\u65f6:" + time;
            if (time >= 8000L) {
                log.error((Object)engMessage);
            } else if (time >= 4000L) {
                log.warn((Object)engMessage);
            } else {
                log.debug((Object)engMessage);
            }
            reviewItem.put("eTime", end);
            reviewItem.put("constTime", time);
        }
    }

    public String runMain(String logicName, String values) throws Exception {
        try {
            Object result = this.run(logicName, values);
            if (result == null) {
                return "";
            }
            if (result instanceof Map) {
                JSONObject json = new JSONObject((Map)result);
                return json.toString();
            }
            if (result instanceof JSONObject) {
                JSONObject json = (JSONObject)result;
                return json.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 1);
            log.error((Object)stack);
            String path = LogicMapper.getLogic(logicName);
            if (path == null) {
                path = logicName;
            }
            this.exceptionLogManage.writeError(ex, path, "/rs/logic/" + logicName, values);
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    @Async(value="AsyncLogicGet")
    public void runAsync(String logicName, String values) throws Exception {
        this.runMain(logicName, values);
    }

    public Object runLogic(String source, JSONObject param, JSONObject context) {
        source = source.replace("\r\n", "\n");
        return ExpressionHelper.run(source, this.getContext(param, context));
    }

    private Map<String, Object> getContext(JSONObject param, JSONObject context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        if (context != null) {
            params.put("context", context);
        }
        params.put("log", log);
        params.put("entity", this.entityServer);
        params.put("sql", this.sqlServer);
        params.put("path", this.pathServer);
        params.put("session", this.sessionPool.getSession());
        params.put("redis", this.redisUtil);
        params.put("logic", this);
        Map<String, Object> plugins = PluginMapper.getPlugins();
        params.putAll(plugins);
        return params;
    }

    public Object noTranscRun(String name, JSONObject param) throws Exception {
        String path = LogicMapper.getLogic(name);
        String source = ResourceHelper.getString("/logics/" + path);
        source = source.replace("\r\n", "\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        params.put("log", log);
        params.put("entity", this.entityServer);
        SqlServer sqlServer = new SqlServer();
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            sqlServer.setAssignedSession(session);
            params.put("sql", sqlServer);
            params.put("session", session);
            params.put("logic", this);
            Map<String, Object> plugins = PluginMapper.getPlugins();
            for (String key : plugins.keySet()) {
                params.put(key, plugins.get(key));
            }
            Object object = ExpressionHelper.run(source, params);
            return object;
        }
    }

    public void debug(String logic, Object msg) {
        String level = LogicMapper.getAttr(logic, "log");
        if (level != null) {
            log.debug((Object)(logic + ":" + String.valueOf(msg)));
        }
    }

    public void redisCacheLogic() {
        if (SystemConfig.Redis.hasHostName() && SystemConfig.Redis.hasRegisterUrl()) {
            String url = SystemConfig.Redis.getRegisterUrl();
            Map<String, Map<String, String>> map = LogicMapper.getMap();
            if (map != null) {
                for (String key : map.keySet()) {
                    this.redisUtil.set(key, url, (Codec)StringCodec.INSTANCE);
                    log.info((Object)("logic\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            if ((map = SqlMapper.getMap()) != null) {
                for (String key : map.keySet()) {
                    this.redisUtil.set(key, url, (Codec)StringCodec.INSTANCE);
                    log.info((Object)("sql\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            if ((map = PathMapper.getMap()) != null) {
                for (String key : map.keySet()) {
                    this.redisUtil.set(key, url, (Codec)StringCodec.INSTANCE);
                    log.info((Object)("path\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            Map entities = this.sessionFactory.getAllClassMetadata();
            for (String key : entities.keySet()) {
                this.redisUtil.set(key, url, (Codec)StringCodec.INSTANCE);
                log.info((Object)("entity\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
            }
        }
    }

    private WebException getWebException(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof WebException)) continue;
            return (WebException)cause;
        }
        return null;
    }
}

