/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.ThreadResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LogicMapper {
    static Logger LOGGER = Logger.getLogger(LogicMapper.class);
    private static Map<String, Map<String, String>> map;

    public static String getLogic(String alias) {
        if (map.containsKey(alias)) {
            String result = LogicMapper.getLogicByUser(alias);
            if (result != null) {
                return result;
            }
            return map.get(alias).get("path");
        }
        return null;
    }

    public static Map<String, Map<String, String>> getMap() {
        return map;
    }

    public static String getAttr(String alias, String name) {
        if (map.containsKey(alias)) {
            return map.get(alias).get(name);
        }
        return null;
    }

    public static String getLogicByUser(String alias) {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = "/" + dir + "/logics/" + alias + ".logic";
        if (map.containsKey(dir + "_" + alias)) {
            return map.get(dir + "_" + alias).get("path");
        }
        SAXReader reader = new SAXReader();
        try {
            LogicMapper.parseOneModule(dir, reader, "filiale", true);
            if (map.containsKey(dir + "_" + alias)) {
                return map.get(dir + "_" + alias).get("path");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Logic\u8fd0\u884c\u8bf7\u6c42\u5934\u5305\u542b\u5206\u516c\u53f8\uff1a" + dir + ",\u83b7\u53d6\u5206\u516c\u53f8\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38:" + path + ",\u5ffd\u7565\u8bf7\u6c42\u5934\u914d\u7f6e"));
        }
        if (LogicMapper.class.getResource(path) != null) {
            return path;
        }
        return null;
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        InputStream module = LogicMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            InputStream input;
            if (module != null) {
                LogicMapper.parseModule(module);
            }
            if ((input = LogicMapper.class.getClassLoader().getResourceAsStream("logic.xml")) != null) {
                LogicMapper.loadOneMap(input, reader, null, null, false);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void loadOneMap(InputStream input, SAXReader reader, String name, String parent, Boolean isFiliale) throws Exception {
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("logic");
        while (it.hasNext()) {
            Element element = (Element)it.next();
            Object aliasLogic = element.attribute("alias").getValue();
            if (isFiliale.booleanValue()) {
                aliasLogic = name + "_" + (String)aliasLogic;
            }
            String pathLogic = element.attribute("path").getValue();
            String log = element.attributeValue("log");
            String mobile = element.attributeValue("mobile");
            String language = element.attributeValue("language");
            if (name != null && map.containsKey(aliasLogic)) {
                throw new Exception("\u522b\u540d" + (String)aliasLogic + "\u5df2\u5b58\u5728");
            }
            String path = LogicMapper.getPath(name, parent, pathLogic);
            HashMap<String, Object> logic = new HashMap<String, Object>();
            logic.put("alias", aliasLogic);
            logic.put("path", path);
            logic.put("log", log);
            logic.put("mobile", mobile);
            logic.put("language", language);
            map.put((String)aliasLogic, logic);
        }
    }

    private static String getPath(String name, String parent, String path) {
        if (name == null) {
            return "logics/" + path;
        }
        if (parent == null) {
            return name + "/logics/" + path;
        }
        return parent + "/" + name + "/logics/" + path;
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            LogicMapper.parseOneModule(name, reader, null, false);
            Iterator children = elm.elementIterator("module");
            while (children.hasNext()) {
                Element childElm = (Element)children.next();
                String childname = childElm.attribute("name").getValue();
                LogicMapper.parseOneModule(childname, reader, name, false);
            }
        }
    }

    private static void parseOneModule(String name, SAXReader reader, String parent, boolean isFiliale) throws Exception {
        String str = parent == null ? name + "/logic.xml" : parent + "/" + name + "/logic.xml";
        InputStream moduleLogic = LogicMapper.class.getClassLoader().getResourceAsStream(str);
        if (moduleLogic == null) {
            throw new RuntimeException("\u6ce8\u610f\uff01\uff01\uff01\u627e\u4e0d\u5230\u6587\u4ef6\uff1a" + str);
        }
        LogicMapper.loadOneMap(moduleLogic, reader, name, parent, isFiliale);
    }

    static {
        LogicMapper.loadMap();
    }
}

