/*
 * Decompiled with CFR 0.152.
 */
package com.aote.entity;

import com.aote.entity.EntityServer;
import com.aote.exception.FileNotFoundException;
import com.aote.util.ResourceHelper;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RulesValidation {
    static final Logger log = Logger.getLogger(EntityServer.class);

    public static void ruleValidation(JSONObject obj, String entityName, String type) throws Exception {
        String getConfig = null;
        try {
            getConfig = ResourceHelper.getString("rules.json");
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"\u65e0\u89c4\u5219\u914d\u7f6e\u6587\u4ef6,\u4e0d\u8fdb\u884c\u9a8c\u8bc1");
            return;
        }
        JSONObject rules = new JSONObject(getConfig);
        JSONObject getEntityRules = null;
        try {
            getEntityRules = (JSONObject)rules.get(entityName);
        }
        catch (JSONException e) {
            log.debug((Object)"\u8be5\u5bf9\u8c61\u4e0d\u9700\u8981\u9a8c\u8bc1");
            return;
        }
        for (String field : getEntityRules.keySet()) {
            JSONObject getField = (JSONObject)getEntityRules.get(field);
            Iterator iterator = getField.keySet().iterator();
            while (iterator.hasNext()) {
                String str;
                switch (str = (String)iterator.next()) {
                    case "update": {
                        RulesValidation.updateValidate(field, obj, getField.get(str));
                        break;
                    }
                    case "enum": {
                        RulesValidation.enumValidate(field, obj, getField.get(str));
                        break;
                    }
                    case "expression": {
                        RulesValidation.expreValidate(field, obj, getField.get(str));
                    }
                }
            }
        }
    }

    private static void updateValidate(String key, JSONObject entity, Object updateObj) throws Exception {
        if (updateObj instanceof String && "false".equals(updateObj) && entity.has(key)) {
            log.error((Object)("\u8be5\u5b57\u6bb5" + key + "\u6839\u636e\u89c4\u5219\u3002\u4e0d\u80fd\u6267\u884c\u66f4\u65b0\u64cd\u4f5c"));
            throw new Exception("\u8be5\u5b57\u6bb5" + key + "\u6839\u636e\u89c4\u5219\u3002\u4e0d\u80fd\u6267\u884c\u66f4\u65b0\u64cd\u4f5c");
        }
        if (updateObj instanceof Boolean && !((Boolean)updateObj).booleanValue() && entity.has(key)) {
            log.error((Object)("\u8be5\u5b57\u6bb5" + key + "\u6839\u636e\u89c4\u5219\u3002\u4e0d\u80fd\u6267\u884c\u66f4\u65b0\u64cd\u4f5c"));
            throw new Exception("\u8be5\u5b57\u6bb5" + key + "\u6839\u636e\u89c4\u5219\u3002\u4e0d\u80fd\u6267\u884c\u66f4\u65b0\u64cd\u4f5c");
        }
        if (updateObj instanceof JSONObject) {
            throw new Exception("\u8be5\u5b57\u6bb5\u7684\u89c4\u5219\u8fd8\u672a\u5f00\u53d1");
        }
    }

    private static void enumValidate(String key, JSONObject entity, Object enumObj) throws Exception {
        if (enumObj instanceof JSONArray && !enumObj.toString().contains(entity.get(key).toString())) {
            log.error((Object)("\u8be5\u5b57\u6bb5" + key + "\u5e94\u5904\u4e8e" + String.valueOf(enumObj)));
            throw new Exception("\u8be5\u5b57\u6bb5" + key + "\u5e94\u5904\u4e8e" + String.valueOf(enumObj));
        }
    }

    private static void expreValidate(String key, JSONObject entity, Object expreObj) {
    }
}

