package com.aote.rs;

import com.aote.ThreadResource;
import com.aote.exception.FileNotFoundException;
import com.aote.rs.mapper.WebException;
import com.aote.util.ResourceHelper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;


@Path("phonevues")
@Singleton
@Component
public class PhonevueService {
    /**
     * 执行业务逻辑(GET方式)
     *
     * @param  vueName 业务逻辑名称
     * @return 执行结果
     */
    @GET
    @Transactional
    @Path("{vue}")
    public String getVueConfig(@PathParam("vue") String vueName)throws Exception {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            // 把文件不存在异常转换成704错误状态
            throw new WebException(704, "用户没有特殊目录！");
        }
        //查看对应目录下是否存在相关vue
        String path =dir + "/phonevues/" +vueName;
        try {
            return ResourceHelper.getString(path);
        } catch (FileNotFoundException e) {
            // 把文件不存在异常转换成704错误状态
            throw new WebException(704, "文件不存在：" + e.getPath());
        }
    }

}
