package com.aote.filter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 18:03 2023/4/13
 */
public class ModifyResponseBodyWrapper extends HttpServletResponseWrapper {


    private ByteArrayOutputStream bos;

    public ModifyResponseBodyWrapper(HttpServletResponse response) {
        super(response);
        this.bos = new ByteArrayOutputStream();
    }

    @Override
    public ServletOutputStream getOutputStream() {
        return new ServletOutputStream() {

            @Override
            public void write(int b) {
                bos.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                bos.write(b);
            }
        };
    }

    @Override
    public PrintWriter getWriter() {
        return new PrintWriter(new OutputStreamWriter(bos));
    }

    public String getResponseBody() throws IOException {
        ServletOutputStream outputStream = this.getOutputStream();
        outputStream.flush();

        PrintWriter writer = this.getWriter();
        writer.flush();

        return bos.toString(StandardCharsets.UTF_8.displayName());
    }
}