/*
 * Decompiled with CFR 0.152.
 */
package com.aote.transaction;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThreadSession {
    static Logger log = Logger.getLogger(ThreadSession.class);
    @Autowired
    private SessionFactory factory;
    private final ThreadLocal<Session> threadLocal = new ThreadLocal();

    public void commit() {
        Session session = this.threadLocal.get();
        if (session != null) {
            try {
                session.flush();
                session.getTransaction().commit();
            }
            finally {
                this.threadLocal.set(null);
                session.close();
            }
        }
    }

    public void rollback() {
        Session session = this.threadLocal.get();
        if (session != null) {
            try {
                session.getTransaction().rollback();
            }
            finally {
                this.threadLocal.set(null);
                session.close();
            }
        }
    }

    public void create() {
        Session session = this.factory.openSession();
        session.beginTransaction();
        this.threadLocal.set(session);
    }

    public Session get() {
        return this.threadLocal.get();
    }
}

