/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.aote.ThreadResource;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthUtil {
    private static final Logger log = LoggerFactory.getLogger(AuthUtil.class);
    private static final String PERMISSION_WILDCARD_ALL = "*:*:*";
    private static final String PERMISSION_SENSITIVE_VIEW_ALL = "sensitive:view:all";
    private static final String PERMISSION_SENSITIVE_VIEW_WILDCARD = "sensitive:view:*";
    private static final String PERMISSION_SENSITIVE_PREFIX = "sensitive:view";

    private AuthUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean hasSensitiveViewPermission(String fieldName) {
        try {
            if (AuthUtil.hasPermission(PERMISSION_WILDCARD_ALL)) {
                log.debug("\u7528\u6237\u5177\u6709\u5168\u5c40\u6743\u9650 {}", (Object)PERMISSION_WILDCARD_ALL);
                return true;
            }
            if (AuthUtil.hasPermission(PERMISSION_SENSITIVE_VIEW_ALL)) {
                log.debug("\u7528\u6237\u5177\u6709\u67e5\u770b\u6240\u6709\u654f\u611f\u5b57\u6bb5\u6743\u9650 {}", (Object)PERMISSION_SENSITIVE_VIEW_ALL);
                return true;
            }
            if (AuthUtil.hasPermission(PERMISSION_SENSITIVE_VIEW_WILDCARD)) {
                log.debug("\u7528\u6237\u5177\u6709\u901a\u914d\u7b26\u6743\u9650 {}\uff0c\u53ef\u67e5\u770b\u5b57\u6bb5 {}", (Object)PERMISSION_SENSITIVE_VIEW_WILDCARD, (Object)fieldName);
                return true;
            }
            String specificPermission = "sensitive:view:" + fieldName;
            if (AuthUtil.hasPermission(specificPermission)) {
                log.debug("\u7528\u6237\u5177\u6709\u7279\u5b9a\u5b57\u6bb5\u6743\u9650 {}", (Object)specificPermission);
                return true;
            }
            log.debug("\u7528\u6237\u65e0\u6743\u9650\u67e5\u770b\u5b57\u6bb5 {}", (Object)fieldName);
            return false;
        }
        catch (Exception e) {
            log.error("\u6743\u9650\u68c0\u67e5\u5f02\u5e38: fieldName={}", (Object)fieldName, (Object)e);
            return false;
        }
    }

    private static boolean hasPermission(String permission) {
        JSONObject loginUser = ThreadResource.LoginUser.get();
        if (loginUser == null) {
            log.debug("\u5f53\u524d\u7ebf\u7a0b\u65e0\u767b\u9646\u7528\u6237\u4fe1\u606f");
            return false;
        }
        JSONArray permissions = loginUser.optJSONArray("permissions");
        if (permissions == null || permissions.length() == 0) {
            log.debug("\u7528\u6237\u65e0\u6743\u9650\u4fe1\u606f");
            return false;
        }
        for (int i = 0; i < permissions.length(); ++i) {
            String userPermission = permissions.optString(i, "");
            if (!permission.equals(userPermission)) continue;
            return true;
        }
        return false;
    }
}

