/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.aote.sensitive.SensitiveDataEnhancer;
import com.aote.sensitive.SensitiveFieldConfigLoader;
import com.aote.sql.AuthUtil;
import com.aote.util.SubstitutionCipherUtil;
import java.io.Reader;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasTransformer
extends AliasedTupleSubsetResultTransformer {
    public static final AliasTransformer INSTANCE = new AliasTransformer();
    private static final Logger log = LoggerFactory.getLogger(AliasTransformer.class);
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT_HOLDER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    private AliasTransformer() {
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(tuple.length);
        Map<String, String> maskMap = SensitiveFieldConfigLoader.getSensitiveMaskMap();
        for (int i = 0; i < aliases.length; ++i) {
            String lowerAlias;
            String alias = aliases[i];
            if (alias == null) continue;
            Object value = tuple[i];
            if (value == null) {
                value = JSONObject.NULL;
            } else if (value instanceof Date) {
                value = DATE_FORMAT_HOLDER.get().format(value);
            } else if (value instanceof Clob) {
                value = AliasTransformer.getClobString((Clob)value);
            } else if (value instanceof String && maskMap.containsKey(lowerAlias = alias.toLowerCase())) {
                value = this.processSensitiveField(lowerAlias, (String)value, maskMap);
            }
            result.put(alias.toLowerCase(), value);
        }
        return result;
    }

    private Object processSensitiveField(String fieldName, String encryptedValue, Map<String, String> maskMap) {
        String plainText = encryptedValue;
        if (SubstitutionCipherUtil.isStrictCipher(encryptedValue)) {
            try {
                plainText = SubstitutionCipherUtil.decrypt(encryptedValue);
            }
            catch (Exception e) {
                log.warn("\u654f\u611f\u5b57\u6bb5\u89e3\u5bc6\u5f02\u5e38: field={}, error={}", (Object)fieldName, (Object)e.getMessage());
                return encryptedValue;
            }
        }
        if (plainText != null) {
            if (AuthUtil.hasSensitiveViewPermission(fieldName)) {
                return plainText;
            }
            String strategy = maskMap.get(fieldName);
            return SensitiveDataEnhancer.applyMaskingStrategy(fieldName, plainText, strategy);
        }
        return encryptedValue;
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public static String getClobString(Clob c) {
        try {
            Reader reader = c.getCharacterStream();
            if (reader == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            char[] charArr = new char[4096];
            int i = reader.read(charArr);
            while (i > 0) {
                sb.append(charArr, 0, i);
                i = reader.read(charArr);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

