/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.config.SystemConfig;
import com.aote.entity.EntityServer;
import com.aote.exception.FileNotFoundException;
import com.aote.module.ModuleMapper;
import com.aote.sql.SqlServer;
import com.aote.util.ResourceHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Path(value="file")
@Component
@Transactional
public class FileService {
    static final Logger log = Logger.getLogger(FileService.class);
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;

    private static byte[] subBytes(byte[] b, int from, int end) {
        byte[] result = new byte[end - from];
        System.arraycopy(b, from, result, 0, end - from);
        return result;
    }

    private static int locateEnd(byte[] bytes, int start, int end, String endStr) {
        byte[] endByte = endStr.getBytes();
        for (int i = start + 1; i < end; ++i) {
            int k;
            if (bytes[i] != endByte[0]) continue;
            for (k = 1; k < endByte.length && bytes[i + k] == endByte[k]; ++k) {
            }
            if (i == 3440488) {
                System.out.println("start");
            }
            if (k != endByte.length) continue;
            return i;
        }
        return 0;
    }

    @POST
    @Path(value="upload")
    public String fileUpload(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        String realpath = this.getPath("uploadFilepath");
        JSONObject result = new JSONObject();
        File file = new File(realpath + File.separator + this.getNowDate());
        if (!file.exists()) {
            file.mkdirs();
        }
        String username = URLDecoder.decode(request.getHeader("username"), "UTF-8");
        String blodid = request.getHeader("blodid");
        String f_usetype = null;
        String f_remarks = null;
        if (request.getHeader("f_usetype") != null) {
            f_usetype = URLDecoder.decode(request.getHeader("f_usetype"), "UTF-8");
        }
        if (request.getHeader("f_remarks") != null) {
            f_remarks = URLDecoder.decode(request.getHeader("f_remarks"), "UTF-8");
        }
        String downloadpath = this.getPath("downloadpath");
        System.out.println(downloadpath);
        System.out.println(username);
        System.out.println(blodid);
        System.out.println(realpath);
        int totalBytes = request.getContentLength();
        System.out.println("\u5f53\u524d\u6570\u636e\u603b\u957f\u5ea6:" + totalBytes);
        String contentType = request.getContentType();
        System.out.println(contentType);
        int position = contentType.indexOf("boundary=");
        String startBoundary = "--" + contentType.substring(position + "boundary=".length());
        String endBoundary = startBoundary + "--";
        ServletInputStream inputStream = request.getInputStream();
        DataInputStream dataInputStream = new DataInputStream((InputStream)inputStream);
        byte[] bytes = new byte[totalBytes];
        dataInputStream.readFully(bytes);
        dataInputStream.close();
        BufferedReader reader = new BufferedReader(new StringReader(new String(bytes)));
        int temPosition = 0;
        boolean flag = false;
        int end = 0;
        while (true) {
            if (flag) {
                bytes = FileService.subBytes(bytes, end, totalBytes);
                temPosition = 0;
                reader = new BufferedReader(new StringReader(new String(bytes)));
            }
            String str = reader.readLine();
            System.out.println("this line is:" + str);
            temPosition += str.getBytes().length + 2;
            if (str.equals(endBoundary)) break;
            if (!str.startsWith(startBoundary)) continue;
            str = reader.readLine();
            temPosition += str.getBytes().length + 2;
            int position1 = str.indexOf("filename=");
            if (position1 == -1) continue;
            int position2 = str.indexOf("name=");
            String name = str.substring(position2 + "name=".length() + 1, position1 - 3);
            String filename = str.substring(position1 + "filename=".length() + 1, str.length() - 1);
            filename = new String(filename.getBytes(), StandardCharsets.UTF_8);
            String uploaddate = this.getDate();
            filename = filename.substring(0, filename.lastIndexOf(46)) + "_" + username + "_" + uploaddate + "." + filename.substring(filename.lastIndexOf(46) + 1);
            System.out.println(filename);
            end = FileService.locateEnd(bytes, temPosition += reader.readLine().getBytes().length + 4, totalBytes, endBoundary);
            DataOutputStream dOutputStream = new DataOutputStream(Files.newOutputStream(new File(file.getAbsolutePath() + File.separator + filename).toPath(), new OpenOption[0]));
            dOutputStream.write(bytes, temPosition, end - temPosition - 2);
            dOutputStream.close();
            flag = true;
            downloadpath = file.getAbsolutePath() + File.separator + filename;
            String filetype = filename.substring(filename.lastIndexOf(46) + 1);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("f_filename", filename);
            map.put("f_username", username);
            map.put("f_blobid", blodid);
            map.put("f_filetype", filetype);
            map.put("f_downloadpath", downloadpath);
            map.put("f_realpath", realpath);
            map.put("f_usetype", f_usetype);
            map.put("f_remarks", f_remarks);
            String jsonFileID = this.entityServer.save("t_files", map);
            JSONObject JObj = new JSONObject(jsonFileID);
            int id = (Integer)JObj.get("id");
            map.put("id", id);
            result = new JSONObject(map);
        }
        result.put("path", (Object)downloadpath);
        result.put("result", (Object)"success");
        System.out.println("1111111111" + result);
        return result.toString();
    }

    @POST
    @Path(value="uploadFile")
    public String fileUpload2(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        String savePath = this.getPath("uploadFilepath");
        if ("".equals(savePath) || savePath == null) {
            savePath = SystemConfig.Resources.getFileRootPath();
        }
        log.info((Object)savePath);
        JSONObject result = new JSONObject();
        File file = new File(savePath + File.separator + this.getNowDate());
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = URLDecoder.decode(request.getHeader(key), "UTF-8");
            map.put(key, value);
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return "";
        }
        List list = upload.parseRequest(request);
        for (FileItem item : list) {
            if (item.isFormField()) continue;
            String filename = item.getName();
            System.out.println("filename===" + filename);
            try {
                this.validateFileName(filename);
            }
            catch (WebApplicationException e) {
                return e.getResponse().toString();
            }
            String uploaddate = this.getDate();
            filename = filename.substring(0, filename.lastIndexOf(46)) + "_" + map.get("username") + "_" + uploaddate + "." + filename.substring(filename.lastIndexOf(46) + 1);
            System.out.println(filename);
            InputStream in = item.getInputStream();
            FileOutputStream out = new FileOutputStream(file.getAbsolutePath() + File.separator + filename);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            in.close();
            out.close();
            item.delete();
            String downloadpath = file.getAbsolutePath() + File.separator + filename;
            String filetype = filename.substring(filename.lastIndexOf(46) + 1);
            if (map.get("blodid") != null && !"".equals(((String)map.get("blodid")).trim())) {
                map.put("f_blobid", map.get("blodid"));
            }
            if (map.containsKey("businessid") && map.get("businessid") != null && !"".equals(((String)map.get("businessid")).trim())) {
                map.put("f_businessid", map.get("businessid"));
            }
            if (map.get("username") != null && !"".equals(((String)map.get("username")).trim())) {
                map.put("f_username", map.get("username"));
            }
            map.put("f_filename", filename);
            map.put("f_filetype", filetype);
            map.put("f_downloadpath", downloadpath);
            map.put("f_realpath", savePath);
            String jsonFileID = this.entityServer.partialSave("t_files", new JSONObject(map));
            JSONObject JObj = new JSONObject(jsonFileID);
            map.put("id", JObj.get("id"));
            result = new JSONObject(map);
        }
        result.put("result", (Object)"success");
        return result.toString();
    }

    @POST
    @Path(value="uploadFileNoLimitFileType")
    public String fileUploadNoLimitFileType(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        String savePath = this.getPath("uploadFilepath");
        JSONObject result = new JSONObject();
        File file = new File(savePath + File.separator + this.getNowDate());
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = URLDecoder.decode(request.getHeader(key), "UTF-8");
            map.put(key, value);
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return "";
        }
        List list = upload.parseRequest(request);
        for (FileItem item : list) {
            if (item.isFormField()) continue;
            String filename = item.getName();
            System.out.println("filename===" + filename);
            if (filename == null || "".equals(filename.trim())) continue;
            String uploaddate = this.getDate();
            filename = filename.substring(0, filename.lastIndexOf(46)) + "_" + map.get("username") + "_" + uploaddate + "." + filename.substring(filename.lastIndexOf(46) + 1);
            System.out.println(filename);
            InputStream in = item.getInputStream();
            FileOutputStream out = new FileOutputStream(file.getAbsolutePath() + File.separator + filename);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            in.close();
            out.close();
            item.delete();
            String downloadpath = file.getAbsolutePath() + File.separator + filename;
            String filetype = filename.substring(filename.lastIndexOf(46) + 1);
            if (map.get("blodid") != null && !"".equals(((String)map.get("blodid")).trim())) {
                map.put("f_blobid", map.get("blodid"));
            }
            if (map.get("username") != null && !"".equals(((String)map.get("username")).trim())) {
                map.put("f_username", map.get("username"));
            }
            map.put("f_filename", filename);
            map.put("f_filetype", filetype);
            map.put("f_downloadpath", downloadpath);
            map.put("f_realpath", savePath);
            String jsonFileID = this.entityServer.partialSave("t_files", new JSONObject(map));
            JSONObject JObj = new JSONObject(jsonFileID);
            map.put("id", JObj.get("id"));
            result = new JSONObject(map);
        }
        result.put("result", (Object)"success");
        return result.toString();
    }

    @POST
    @Path(value="uploadFileNew")
    public String fileUploadNew(@Context HttpServletRequest request, @Context HttpServletResponse response, @QueryParam(value="FileName") String filename, @QueryParam(value="BlobId") String blob_id, @QueryParam(value="EntityName") String EntityName) throws Exception {
        String savePath = this.getPath("uploadFilepath");
        File file = new File(savePath + File.separator + this.getNowDate());
        if (!file.exists()) {
            file.mkdirs();
        }
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = URLDecoder.decode(request.getHeader(key), "UTF-8");
            map.put(key, value);
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return "";
        }
        List list = upload.parseRequest(request);
        String realFileName = null;
        String result = null;
        for (FileItem item : list) {
            if (item.isFormField()) continue;
            CommonsMultipartFile mf = new CommonsMultipartFile(item);
            realFileName = mf.getOriginalFilename();
            String name1 = mf.getName();
            String fileName = realFileName.substring(0, realFileName.lastIndexOf(46));
            String fileType = realFileName.substring(realFileName.lastIndexOf(46));
            String uploadDate = this.getDate();
            realFileName = map.containsKey("username") ? fileName + "_" + map.get("username") + "_" + uploadDate + fileType : fileName + "_" + uploadDate + fileType;
            if (EntityName != null && EntityName.equals("t_blob")) {
                try {
                    map.put("filename", filename);
                    map.put("id", blob_id);
                    Session session = this.sessionFactory.getCurrentSession();
                    map.put("blob", Hibernate.getLobCreator((Session)session).createBlob(mf.getBytes()));
                    session.saveOrUpdate(EntityName, map);
                    session.flush();
                    result = "";
                    continue;
                }
                catch (Exception e) {
                    throw new WebApplicationException(500);
                }
            }
            JSONObject params = new JSONObject();
            String downloadpath = file.getAbsolutePath() + File.separator + filename;
            try {
                mf.transferTo(new File(downloadpath));
                if (map.get("blodid") != null && !"".equals(((String)map.get("blodid")).trim())) {
                    map.put("f_blobid", map.get("blodid"));
                }
                if (map.get("username") != null && !"".equals(((String)map.get("username")).trim())) {
                    map.put("f_username", map.get("username"));
                }
                map.put("f_filename", filename);
                map.put("f_filetype", fileType);
                map.put("f_downloadpath", downloadpath);
                map.put("f_realpath", savePath);
                String jsonFileID = this.entityServer.partialSave("t_files", new JSONObject(map));
                JSONObject JObj = new JSONObject(jsonFileID);
                map.put("id", JObj.get("id"));
                params = new JSONObject(map);
                params.put("result", (Object)"success");
            }
            catch (IOException e) {
                e.printStackTrace();
                params.put("result", (Object)"error");
            }
            result = params.toString();
        }
        return result;
    }

    @Path(value="getUploadFile")
    @POST
    public byte[] getFileOfFilePath(@Context HttpServletRequest request, @Context HttpServletResponse response, String values) {
        try {
            values = values.replaceAll("\\\\", "/");
            JSONObject params = new JSONObject(values);
            Object object = params.get("filepath");
            String filepath = (String)object;
            System.out.println(filepath);
            File file = new File(filepath);
            String filename = filepath.substring(filepath.lastIndexOf("/") + 1);
            FileInputStream in = new FileInputStream(file);
            byte[] result = new byte[(int)file.length()];
            in.read(result);
            in.close();
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Path(value="savefile")
    @POST
    public String savefile(byte[] file, @QueryParam(value="filename") String filename, @QueryParam(value="module") String module) {
        try {
            String realpath = ModuleMapper.getAttr(module, "upload");
            realpath = this.getRealPath(realpath) + File.separator + filename;
            DataOutputStream dOutputStream = new DataOutputStream(Files.newOutputStream(new File(realpath).toPath(), new OpenOption[0]));
            dOutputStream.write(file);
            dOutputStream.close();
            String filetype = filename.split("\\.")[1];
            JSONObject map = new JSONObject();
            map.put("f_filename", (Object)filename);
            String uploaddate = this.getFileUploadDate();
            map.put("f_uploaddate", (Object)uploaddate);
            map.put("f_filetype", (Object)filetype);
            map.put("f_realpath", (Object)realpath);
            map.put("f_downloadpath", (Object)realpath);
            JSONObject result = new JSONObject(this.entityServer.partialSave("t_files", map));
            return result.getString("id");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="getfile/{id}")
    @GET
    public byte[] getfile(@PathParam(value="id") String id) {
        try {
            JSONArray array = this.sqlServer.query("select f_downloadpath from t_files where id=" + id);
            if (array.length() == 0) {
                return null;
            }
            JSONObject map = array.getJSONObject(0);
            String filename = map.getString("f_downloadpath");
            File file = new File(filename);
            try (FileInputStream in = new FileInputStream(file);){
                byte[] result = new byte[(int)file.length()];
                in.read(result);
                byte[] byArray = result;
                return byArray;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Path(value="getfile2/{id}")
    @GET
    public String getfile2(@PathParam(value="id") String id) {
        try {
            byte[] files = this.getfile(id);
            Base64.Encoder encoder = Base64.getEncoder();
            return new String(encoder.encode(files), StandardCharsets.UTF_8);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void transformStream(InputStream is, OutputStream os) {
        try {
            byte[] buffer = new byte[1024];
            int length = is.read(buffer);
            while (length != -1) {
                os.write(buffer, 0, length);
                length = is.read(buffer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getRealPath(String realpath) {
        Date d = new Date();
        realpath = realpath + File.separator + (d.getYear() + 1900) + File.separator + (d.getMonth() + 1) + File.separator + d.getDate();
        File f = new File(realpath);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            return realpath;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean validateFileName(String name) {
        if (name == null || "".equals(name) || this.containsTraversalCharacters(name)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"code\":400,\"message\":\"Invalid file name: " + name + "\"}")).type("application/json").build());
        }
        String[] uploadType = new String[]{"doc", "docx", "xls", "xlsx", "jpg", "png", "gif", "bmp", "avi", "mp4", "wmv", "rmvb", "mov", "pdf", "dwg"};
        String suffix = this.getSuffix(name).toLowerCase();
        if (!Arrays.asList(uploadType).contains(suffix)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"code\":400,\"message\":\"Unsupported file type: " + suffix + "\"}")).type("application/json").build());
        }
        return true;
    }

    private boolean containsTraversalCharacters(String name) {
        return name.contains("..") || name.contains("/") || name.contains("\\");
    }

    private String getSuffix(String name) {
        return name.split("\\.")[name.split("\\.").length - 1];
    }

    private String getNowDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    public String getDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(new Date());
    }

    public String getFileUploadDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPath(String pathname) {
        String proPath = System.getProperty("user.dir");
        Properties pro = new Properties();
        try (FileInputStream in = new FileInputStream(proPath + "/file.properties");){
            pro.load(in);
            String path = pro.getProperty(pathname);
            System.out.println(path);
            in.close();
            String string = path;
            return string;
        }
        catch (Exception e) {
            log.error((Object)"\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01");
            return "";
        }
    }

    @POST
    @Path(value="deleteFile")
    public String deleteFile(@Context HttpServletRequest request, @Context HttpServletResponse response) throws JSONException, IOException {
        request.setCharacterEncoding("utf-8");
        JSONObject obj = new JSONObject(new JSONTokener((InputStream)request.getInputStream()));
        System.out.println(obj);
        String path = new String(obj.getString("path").getBytes(), StandardCharsets.UTF_8);
        String blobid = obj.getString("blobid");
        System.out.println(path);
        path.split("/");
        System.out.println(blobid);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
            Session session = this.sessionFactory.openSession();
            Query query = session.createQuery("delete from t_files where blobid='" + blobid + "' and " + "filename='" + path.split("/")[path.split("/").length - 1] + "'");
            query.executeUpdate();
            session.close();
            System.out.println("success");
            return "success";
        }
        System.out.println("file is not exists");
        return "file is not exists";
    }

    @GET
    @Path(value="vue/{filename}")
    public String getVueFile(@PathParam(value="filename") String fileName) {
        log.debug((Object)fileName);
        String result = null;
        try {
            result = ResourceHelper.getString("/vue/" + fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("/vue/" + fileName + " \u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        return result;
    }

    private String makeFileName(String filename) {
        return UUID.randomUUID() + "_" + filename;
    }

    private String makePath(String filename, String savePath) {
        int hashcode = filename.hashCode();
        File file = new File(savePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return savePath;
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="fileSave")
    public String saveFile(@Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

